<?php
// Definir tempo de execução ilimitado
set_time_limit(0);
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// Função para log
function logMessage($message) {
    echo $message . "<br>";
    flush();
    ob_flush();
}

try {
    // Conectar ao banco de dados
    require_once 'config/database.php';
    $database = new Database();
    $db = $database->getConnection();
    
    logMessage("✅ Conexão com o banco de dados estabelecida");

    // 1. Adicionar coluna codigo_barras na tabela produtos
    try {
        $sql = "ALTER TABLE produtos ADD COLUMN IF NOT EXISTS codigo_barras VARCHAR(50) AFTER nome";
        $db->exec($sql);
        logMessage("✅ Campo 'codigo_barras' adicionado na tabela produtos");
    } catch (PDOException $e) {
        if (strpos($e->getMessage(), 'Duplicate column name') !== false) {
            logMessage("ℹ️ Campo 'codigo_barras' já existe na tabela produtos");
        } else {
            throw $e;
        }
    }

    // 2. Atualizar o arquivo clientes.js
    $clientesJsPath = __DIR__ . '/assets/js/clientes.js';
    if (file_exists($clientesJsPath)) {
        $content = file_get_contents($clientesJsPath);
        
        // Verificar se a ordenação já existe
        if (strpos($content, "order: [[1, 'asc']]") === false) {
            // Encontrar a posição após a definição das colunas
            $pos = strpos($content, "columns: [");
            if ($pos !== false) {
                $pos = strpos($content, "],", $pos);
                if ($pos !== false) {
                    $newContent = substr($content, 0, $pos + 2) . "\n        order: [[1, 'asc']], // Ordenação alfabética por nome" . substr($content, $pos + 2);
                    
                    // Fazer backup do arquivo original
                    $backupPath = $clientesJsPath . '.bak.' . date('Y-m-d-H-i-s');
                    copy($clientesJsPath, $backupPath);
                    
                    // Salvar as alterações
                    file_put_contents($clientesJsPath, $newContent);
                    logMessage("✅ Arquivo clientes.js atualizado com ordenação alfabética");
                    logMessage("ℹ️ Backup criado em: " . basename($backupPath));
                } else {
                    throw new Exception("Não foi possível encontrar o local correto para inserir a ordenação em clientes.js");
                }
            } else {
                throw new Exception("Estrutura do arquivo clientes.js não encontrada");
            }
        } else {
            logMessage("ℹ️ Ordenação alfabética já existe em clientes.js");
        }
    } else {
        throw new Exception("Arquivo clientes.js não encontrado");
    }

    // 3. Atualizar o arquivo produtos.php para incluir o campo de código de barras
    $produtosPhpPath = __DIR__ . '/produtos.php';
    if (file_exists($produtosPhpPath)) {
        $content = file_get_contents($produtosPhpPath);
        
        // Verificar se o campo já existe
        if (strpos($content, 'name="codigo_barras"') === false) {
            // Encontrar a posição após o campo nome
            $searchStr = '<input type="text" class="form-control" name="nome" required>';
            $pos = strpos($content, $searchStr);
            if ($pos !== false) {
                $pos = $pos + strlen($searchStr);
                
                $newField = "\n\n                    <div class=\"mb-3\">\n                        <label class=\"form-label\">Código de Barras</label>\n                        <input type=\"text\" class=\"form-control\" name=\"codigo_barras\" placeholder=\"Digite ou use um leitor de código de barras\">\n                    </div>";
                
                $newContent = substr($content, 0, $pos) . $newField . substr($content, $pos);
                
                // Fazer backup do arquivo original
                $backupPath = $produtosPhpPath . '.bak.' . date('Y-m-d-H-i-s');
                copy($produtosPhpPath, $backupPath);
                
                // Salvar as alterações
                file_put_contents($produtosPhpPath, $newContent);
                logMessage("✅ Arquivo produtos.php atualizado com campo de código de barras");
                logMessage("ℹ️ Backup criado em: " . basename($backupPath));
            } else {
                throw new Exception("Não foi possível encontrar o local correto para inserir o campo em produtos.php");
            }
        } else {
            logMessage("ℹ️ Campo de código de barras já existe em produtos.php");
        }
    } else {
        throw new Exception("Arquivo produtos.php não encontrado");
    }

    logMessage("\n✨ Atualização concluída com sucesso!");
    logMessage("\n⚠️ Importante:");
    logMessage("1. Limpe o cache do navegador (Ctrl+F5) ao acessar as páginas atualizadas");
    logMessage("2. Verifique se as alterações foram aplicadas corretamente");
    logMessage("3. Em caso de problemas, os arquivos de backup foram criados com extensão .bak");

} catch (Exception $e) {
    logMessage("\n❌ Erro durante a atualização: " . $e->getMessage());
    if (isset($db)) {
        logMessage("Detalhes do erro: " . print_r($e, true));
    }
}
