-- phpMyAdmin SQL Dump
-- version 5.2.1
-- https://www.phpmyadmin.net/
--
-- Host: 127.0.0.1
-- Tempo de geração: 05/01/2025 às 15:31
-- Versão do servidor: 10.4.32-MariaDB
-- Versão do PHP: 8.2.12

SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
START TRANSACTION;
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;

--
-- Banco de dados: `digin`
--

-- --------------------------------------------------------

--
-- Estrutura para tabela `caixa`
--

CREATE TABLE `caixa` (
  `id` int(11) NOT NULL,
  `status` enum('aberto','fechado') NOT NULL,
  `valor_abertura` decimal(10,2) NOT NULL,
  `valor_fechamento` decimal(10,2) DEFAULT NULL,
  `data_abertura` datetime NOT NULL,
  `data_fechamento` datetime DEFAULT NULL,
  `usuario_id` int(11) NOT NULL,
  `observacao` text DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `valor_total` decimal(10,2) DEFAULT 0.00
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Estrutura para tabela `campanhas`
--

CREATE TABLE `campanhas` (
  `id` int(11) NOT NULL,
  `nome` varchar(255) NOT NULL,
  `descricao` text DEFAULT NULL,
  `imagem` varchar(255) DEFAULT NULL,
  `status` enum('Enviada','Pendente','Erro') DEFAULT 'Pendente',
  `data_criacao` datetime DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Estrutura para tabela `campanha_destinatarios`
--

CREATE TABLE `campanha_destinatarios` (
  `id` int(11) NOT NULL,
  `campanha_id` int(11) NOT NULL,
  `cliente_id` int(11) NOT NULL,
  `status` enum('pendente','enviado','erro') DEFAULT 'pendente',
  `data_envio` datetime DEFAULT NULL,
  `created_at` datetime DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Estrutura para tabela `categorias`
--

CREATE TABLE `categorias` (
  `id` int(11) NOT NULL,
  `nome` varchar(100) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `deleted_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Estrutura para tabela `clientes`
--

CREATE TABLE `clientes` (
  `id` int(11) NOT NULL,
  `nome` varchar(100) NOT NULL,
  `data_nascimento` date DEFAULT NULL,
  `endereco` varchar(200) DEFAULT NULL,
  `numero` varchar(10) DEFAULT NULL,
  `bairro` varchar(100) DEFAULT NULL,
  `cidade` varchar(100) DEFAULT NULL,
  `telefone` varchar(20) DEFAULT NULL,
  `instagram` varchar(100) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `deleted_at` datetime DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Estrutura para tabela `config_empresa`
--

CREATE TABLE `config_empresa` (
  `id` int(11) NOT NULL,
  `nome_empresa` varchar(255) NOT NULL DEFAULT 'DIGIN MODELO',
  `logo` varchar(255) DEFAULT NULL,
  `cnpj` varchar(20) DEFAULT NULL,
  `telefone` varchar(20) DEFAULT NULL,
  `whatsapp` varchar(20) DEFAULT NULL,
  `email` varchar(100) DEFAULT NULL,
  `instagram` varchar(100) DEFAULT NULL,
  `endereco` text DEFAULT NULL,
  `numero` varchar(10) DEFAULT NULL,
  `bairro` varchar(100) DEFAULT NULL,
  `cep` varchar(10) DEFAULT NULL,
  `cidade` varchar(100) DEFAULT NULL,
  `celular` varchar(20) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `cupom_message` text DEFAULT 'Obrigado pela preferência! Volte sempre!'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Despejando dados para a tabela `config_empresa`
--

INSERT INTO `config_empresa` (`id`, `nome_empresa`, `logo`, `cnpj`, `telefone`, `whatsapp`, `email`, `instagram`, `endereco`, `numero`, `bairro`, `cep`, `cidade`, `celular`, `created_at`, `updated_at`, `cupom_message`) VALUES
(1, 'DIGIN MODELO', 'uploads/logo.jpg', '', '', '', '', '', '', '', '', '', '', '', '2024-12-09 17:15:17', '2024-12-16 16:12:59', 'Obrigado pela preferência! \r\nVolte sempre!');

-- --------------------------------------------------------

--
-- Estrutura para tabela `config_estilo_cores`
--

CREATE TABLE `config_estilo_cores` (
  `id` int(11) NOT NULL,
  `cor_principal` varchar(7) DEFAULT '#1923ae',
  `cor_secundaria` varchar(7) DEFAULT '#b88700',
  `cor_terciaria` varchar(7) DEFAULT '#166053',
  `cor_texto` varchar(7) DEFAULT '#166053',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Despejando dados para a tabela `config_estilo_cores`
--

INSERT INTO `config_estilo_cores` (`id`, `cor_principal`, `cor_secundaria`, `cor_terciaria`, `cor_texto`, `created_at`, `updated_at`) VALUES
(1, '#0071b8', '#030e5e', '#ffffff', '#020200', '2024-11-25 23:11:06', '2024-12-16 16:07:45');

-- --------------------------------------------------------

--
-- Estrutura para tabela `config_history`
--

CREATE TABLE `config_history` (
  `id` int(11) NOT NULL,
  `config_type` varchar(50) NOT NULL,
  `config_data` text NOT NULL,
  `user_id` int(11) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `description` text DEFAULT NULL,
  `ip_address` varchar(45) DEFAULT NULL,
  `revert_hash` varchar(32) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Despejando dados para a tabela `config_history`
--

INSERT INTO `config_history` (`id`, `config_type`, `config_data`, `user_id`, `created_at`, `description`, `ip_address`, `revert_hash`) VALUES
(25, 'redes_sociais', '{\"facebook\":\"\",\"instagram\":\"\",\"tiktok\":\"\",\"linkedin\":\"\"}', NULL, '2024-12-16 16:12:50', 'Atualização das redes sociais', '45.180.129.48', '7194ac3ed630ba76a1ae96fd23ff0e12');

-- --------------------------------------------------------

--
-- Estrutura para tabela `config_redes_sociais`
--

CREATE TABLE `config_redes_sociais` (
  `id` int(11) NOT NULL,
  `facebook` varchar(255) DEFAULT '',
  `instagram` varchar(255) DEFAULT '',
  `tiktok` varchar(255) DEFAULT '',
  `linkedin` varchar(255) DEFAULT '',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Despejando dados para a tabela `config_redes_sociais`
--

INSERT INTO `config_redes_sociais` (`id`, `facebook`, `instagram`, `tiktok`, `linkedin`, `created_at`, `updated_at`) VALUES
(1, '', '', '', '', '2024-11-25 23:25:44', '2024-12-16 16:12:29');

-- --------------------------------------------------------

--
-- Estrutura para tabela `config_site`
--

CREATE TABLE `config_site` (
  `id` int(11) NOT NULL,
  `site_ativo` tinyint(1) NOT NULL DEFAULT 0,
  `ultima_atualizacao` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `slide_ativo` tinyint(1) DEFAULT 1,
  `slide_image` varchar(255) DEFAULT NULL,
  `slide_texto_principal` varchar(255) DEFAULT 'Bem-vinda à Garota',
  `slide_texto_secundario` varchar(255) DEFAULT 'Descubra nossa nova coleção',
  `nome_empresa` varchar(255) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Despejando dados para a tabela `config_site`
--

INSERT INTO `config_site` (`id`, `site_ativo`, `ultima_atualizacao`, `slide_ativo`, `slide_image`, `slide_texto_principal`, `slide_texto_secundario`, `nome_empresa`) VALUES
(1, 1, '2024-12-16 16:04:09', 1, 'uploads/slides/slide_67604f792cf00_1734365049.jpg', 'Bem vindo a Loja', 'Descubra nossa nova coleção', '');

-- --------------------------------------------------------

--
-- Estrutura para tabela `marketing_campanhas`
--

CREATE TABLE `marketing_campanhas` (
  `id` int(11) NOT NULL,
  `nome` varchar(255) NOT NULL,
  `descricao` text DEFAULT NULL,
  `imagem` varchar(255) DEFAULT NULL,
  `data_envio` datetime DEFAULT current_timestamp(),
  `status` enum('pendente','enviado','erro') DEFAULT 'pendente',
  `created_at` datetime DEFAULT current_timestamp(),
  `updated_at` datetime DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `deleted_at` datetime DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Estrutura para tabela `marketing_destinatarios`
--

CREATE TABLE `marketing_destinatarios` (
  `id` int(11) NOT NULL,
  `campanha_id` int(11) NOT NULL,
  `cliente_id` int(11) NOT NULL,
  `status` enum('pendente','enviado','erro') DEFAULT 'pendente',
  `data_envio` datetime DEFAULT NULL,
  `created_at` datetime DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Estrutura para tabela `movimentacoes_caixa`
--

CREATE TABLE `movimentacoes_caixa` (
  `id` int(11) NOT NULL,
  `tipo` enum('entrada','saida') NOT NULL,
  `valor` decimal(10,2) NOT NULL,
  `data_hora` datetime NOT NULL,
  `descricao` text DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Estrutura para tabela `operacao_itens`
--

CREATE TABLE `operacao_itens` (
  `id` int(11) NOT NULL,
  `operacao_id` int(11) NOT NULL,
  `produto_id` int(11) NOT NULL,
  `tamanho` varchar(10) NOT NULL,
  `quantidade` int(11) NOT NULL,
  `valor_unitario` decimal(10,2) NOT NULL,
  `created_at` datetime DEFAULT current_timestamp(),
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Estrutura para tabela `operacoes`
--

CREATE TABLE `operacoes` (
  `id` int(11) NOT NULL,
  `cliente_id` int(11) DEFAULT NULL,
  `tipo` enum('venda','prova') NOT NULL,
  `valor_total` decimal(10,2) NOT NULL,
  `afeta_caixa` tinyint(1) NOT NULL DEFAULT 1,
  `metodo_pagamento` varchar(50) DEFAULT NULL,
  `valor_recebido` decimal(10,2) DEFAULT NULL,
  `status` varchar(20) DEFAULT 'ativo',
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Estrutura para tabela `pagamentos_crediario`
--

CREATE TABLE `pagamentos_crediario` (
  `id` int(11) NOT NULL,
  `venda_id` int(11) DEFAULT NULL,
  `valor_pago` decimal(10,2) NOT NULL,
  `data_pagamento` datetime NOT NULL,
  `usuario_id` int(11) DEFAULT NULL,
  `cliente_id` int(11) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Estrutura para tabela `pagamentos_parciais`
--

CREATE TABLE `pagamentos_parciais` (
  `id` int(11) NOT NULL,
  `venda_id` int(11) NOT NULL,
  `valor` decimal(10,2) NOT NULL,
  `data_pagamento` datetime NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Estrutura para tabela `produtos`
--

CREATE TABLE `produtos` (
  `id` int(11) NOT NULL,
  `nome` varchar(255) NOT NULL,
  `codigo_barras` varchar(50) DEFAULT NULL,
  `categoria_id` int(11) NOT NULL,
  `valor` decimal(10,2) NOT NULL,
  `imagem` varchar(255) NOT NULL,
  `cor` varchar(50) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `deleted_at` timestamp NULL DEFAULT NULL,
  `tamanhos` varchar(255) DEFAULT NULL COMMENT 'Tamanhos disponíveis separados por vírgula',
  `preco` decimal(10,2) DEFAULT 0.00 COMMENT 'Preço do produto',
  `tamanho` varchar(50) DEFAULT NULL COMMENT 'Tamanho do produto',
  `repeater` text DEFAULT NULL COMMENT 'Campo para armazenar variações de tamanho do produto'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Estrutura para tabela `produto_tamanhos`
--

CREATE TABLE `produto_tamanhos` (
  `id` int(11) NOT NULL,
  `produto_id` int(11) NOT NULL,
  `tamanho` varchar(10) NOT NULL,
  `estoque` int(11) NOT NULL DEFAULT 0,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Estrutura para tabela `usuarios`
--

CREATE TABLE `usuarios` (
  `id` int(11) NOT NULL,
  `nome` varchar(255) NOT NULL,
  `senha` varchar(255) NOT NULL,
  `permissoes` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`permissoes`)),
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Despejando dados para a tabela `usuarios`
--

INSERT INTO `usuarios` (`id`, `nome`, `senha`, `permissoes`, `created_at`, `updated_at`) VALUES
(1, 'admin', '$2y$10$/3mDP4aJBXYumjXQty8NZ.ol4.dsbJHHyoFZNt50exVTw4qSglqXq', '[\"dashboard\",\"clientes\",\"produtos\",\"pdv\",\"caixa\",\"vendas\",\"provas\",\"relatorios\",\"usuarios\",\"configuracoes\"]', '2024-12-10 23:27:17', '2024-12-10 23:27:17');

-- --------------------------------------------------------

--
-- Estrutura para tabela `vendas`
--

CREATE TABLE `vendas` (
  `id` int(11) NOT NULL,
  `operacao_id` int(11) DEFAULT NULL,
  `usuario_id` int(11) DEFAULT NULL,
  `cliente_id` int(11) DEFAULT NULL,
  `valor_total` decimal(10,2) NOT NULL,
  `data_venda` datetime NOT NULL,
  `status` varchar(50) DEFAULT 'concluida',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Índices para tabelas despejadas
--

--
-- Índices de tabela `caixa`
--
ALTER TABLE `caixa`
  ADD PRIMARY KEY (`id`);

--
-- Índices de tabela `campanhas`
--
ALTER TABLE `campanhas`
  ADD PRIMARY KEY (`id`);

--
-- Índices de tabela `campanha_destinatarios`
--
ALTER TABLE `campanha_destinatarios`
  ADD PRIMARY KEY (`id`),
  ADD KEY `campanha_id` (`campanha_id`),
  ADD KEY `cliente_id` (`cliente_id`);

--
-- Índices de tabela `categorias`
--
ALTER TABLE `categorias`
  ADD PRIMARY KEY (`id`);

--
-- Índices de tabela `clientes`
--
ALTER TABLE `clientes`
  ADD PRIMARY KEY (`id`);

--
-- Índices de tabela `config_empresa`
--
ALTER TABLE `config_empresa`
  ADD PRIMARY KEY (`id`);

--
-- Índices de tabela `config_estilo_cores`
--
ALTER TABLE `config_estilo_cores`
  ADD PRIMARY KEY (`id`);

--
-- Índices de tabela `config_history`
--
ALTER TABLE `config_history`
  ADD PRIMARY KEY (`id`);

--
-- Índices de tabela `config_redes_sociais`
--
ALTER TABLE `config_redes_sociais`
  ADD PRIMARY KEY (`id`);

--
-- Índices de tabela `config_site`
--
ALTER TABLE `config_site`
  ADD PRIMARY KEY (`id`);

--
-- Índices de tabela `marketing_campanhas`
--
ALTER TABLE `marketing_campanhas`
  ADD PRIMARY KEY (`id`);

--
-- Índices de tabela `marketing_destinatarios`
--
ALTER TABLE `marketing_destinatarios`
  ADD PRIMARY KEY (`id`),
  ADD KEY `campanha_id` (`campanha_id`),
  ADD KEY `cliente_id` (`cliente_id`);

--
-- Índices de tabela `movimentacoes_caixa`
--
ALTER TABLE `movimentacoes_caixa`
  ADD PRIMARY KEY (`id`);

--
-- Índices de tabela `operacao_itens`
--
ALTER TABLE `operacao_itens`
  ADD PRIMARY KEY (`id`),
  ADD KEY `operacao_id` (`operacao_id`),
  ADD KEY `produto_id` (`produto_id`);

--
-- Índices de tabela `operacoes`
--
ALTER TABLE `operacoes`
  ADD PRIMARY KEY (`id`),
  ADD KEY `cliente_id` (`cliente_id`);

--
-- Índices de tabela `pagamentos_crediario`
--
ALTER TABLE `pagamentos_crediario`
  ADD PRIMARY KEY (`id`),
  ADD KEY `venda_id` (`venda_id`);

--
-- Índices de tabela `pagamentos_parciais`
--
ALTER TABLE `pagamentos_parciais`
  ADD PRIMARY KEY (`id`),
  ADD KEY `venda_id` (`venda_id`);

--
-- Índices de tabela `produtos`
--
ALTER TABLE `produtos`
  ADD PRIMARY KEY (`id`),
  ADD KEY `categoria_id` (`categoria_id`);

--
-- Índices de tabela `produto_tamanhos`
--
ALTER TABLE `produto_tamanhos`
  ADD PRIMARY KEY (`id`),
  ADD KEY `produto_id` (`produto_id`);

--
-- Índices de tabela `usuarios`
--
ALTER TABLE `usuarios`
  ADD PRIMARY KEY (`id`);

--
-- Índices de tabela `vendas`
--
ALTER TABLE `vendas`
  ADD PRIMARY KEY (`id`),
  ADD KEY `operacao_id` (`operacao_id`),
  ADD KEY `usuario_id` (`usuario_id`),
  ADD KEY `cliente_id` (`cliente_id`);

--
-- AUTO_INCREMENT para tabelas despejadas
--

--
-- AUTO_INCREMENT de tabela `caixa`
--
ALTER TABLE `caixa`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=4;

--
-- AUTO_INCREMENT de tabela `campanhas`
--
ALTER TABLE `campanhas`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT de tabela `campanha_destinatarios`
--
ALTER TABLE `campanha_destinatarios`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT de tabela `categorias`
--
ALTER TABLE `categorias`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=7;

--
-- AUTO_INCREMENT de tabela `clientes`
--
ALTER TABLE `clientes`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=9;

--
-- AUTO_INCREMENT de tabela `config_empresa`
--
ALTER TABLE `config_empresa`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=2;

--
-- AUTO_INCREMENT de tabela `config_estilo_cores`
--
ALTER TABLE `config_estilo_cores`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=2;

--
-- AUTO_INCREMENT de tabela `config_history`
--
ALTER TABLE `config_history`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=26;

--
-- AUTO_INCREMENT de tabela `config_redes_sociais`
--
ALTER TABLE `config_redes_sociais`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=2;

--
-- AUTO_INCREMENT de tabela `config_site`
--
ALTER TABLE `config_site`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=2;

--
-- AUTO_INCREMENT de tabela `marketing_campanhas`
--
ALTER TABLE `marketing_campanhas`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT de tabela `marketing_destinatarios`
--
ALTER TABLE `marketing_destinatarios`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT de tabela `movimentacoes_caixa`
--
ALTER TABLE `movimentacoes_caixa`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=3;

--
-- AUTO_INCREMENT de tabela `operacao_itens`
--
ALTER TABLE `operacao_itens`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=10;

--
-- AUTO_INCREMENT de tabela `operacoes`
--
ALTER TABLE `operacoes`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=9;

--
-- AUTO_INCREMENT de tabela `pagamentos_crediario`
--
ALTER TABLE `pagamentos_crediario`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=3;

--
-- AUTO_INCREMENT de tabela `pagamentos_parciais`
--
ALTER TABLE `pagamentos_parciais`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=3;

--
-- AUTO_INCREMENT de tabela `produtos`
--
ALTER TABLE `produtos`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=4;

--
-- AUTO_INCREMENT de tabela `produto_tamanhos`
--
ALTER TABLE `produto_tamanhos`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=16;

--
-- AUTO_INCREMENT de tabela `usuarios`
--
ALTER TABLE `usuarios`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=3;

--
-- AUTO_INCREMENT de tabela `vendas`
--
ALTER TABLE `vendas`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=5;

--
-- Restrições para tabelas despejadas
--

--
-- Restrições para tabelas `campanha_destinatarios`
--
ALTER TABLE `campanha_destinatarios`
  ADD CONSTRAINT `campanha_destinatarios_ibfk_1` FOREIGN KEY (`campanha_id`) REFERENCES `campanhas` (`id`),
  ADD CONSTRAINT `campanha_destinatarios_ibfk_2` FOREIGN KEY (`cliente_id`) REFERENCES `clientes` (`id`);

--
-- Restrições para tabelas `marketing_destinatarios`
--
ALTER TABLE `marketing_destinatarios`
  ADD CONSTRAINT `marketing_destinatarios_ibfk_1` FOREIGN KEY (`campanha_id`) REFERENCES `marketing_campanhas` (`id`),
  ADD CONSTRAINT `marketing_destinatarios_ibfk_2` FOREIGN KEY (`cliente_id`) REFERENCES `clientes` (`id`);

--
-- Restrições para tabelas `operacao_itens`
--
ALTER TABLE `operacao_itens`
  ADD CONSTRAINT `operacao_itens_ibfk_1` FOREIGN KEY (`operacao_id`) REFERENCES `operacoes` (`id`),
  ADD CONSTRAINT `operacao_itens_ibfk_2` FOREIGN KEY (`produto_id`) REFERENCES `produtos` (`id`);

--
-- Restrições para tabelas `operacoes`
--
ALTER TABLE `operacoes`
  ADD CONSTRAINT `operacoes_ibfk_1` FOREIGN KEY (`cliente_id`) REFERENCES `clientes` (`id`);

--
-- Restrições para tabelas `pagamentos_crediario`
--
ALTER TABLE `pagamentos_crediario`
  ADD CONSTRAINT `pagamentos_crediario_ibfk_1` FOREIGN KEY (`venda_id`) REFERENCES `operacoes` (`id`) ON DELETE CASCADE;

--
-- Restrições para tabelas `pagamentos_parciais`
--
ALTER TABLE `pagamentos_parciais`
  ADD CONSTRAINT `pagamentos_parciais_ibfk_1` FOREIGN KEY (`venda_id`) REFERENCES `operacoes` (`id`);

--
-- Restrições para tabelas `produtos`
--
ALTER TABLE `produtos`
  ADD CONSTRAINT `produtos_ibfk_1` FOREIGN KEY (`categoria_id`) REFERENCES `categorias` (`id`);

--
-- Restrições para tabelas `produto_tamanhos`
--
ALTER TABLE `produto_tamanhos`
  ADD CONSTRAINT `produto_tamanhos_ibfk_1` FOREIGN KEY (`produto_id`) REFERENCES `produtos` (`id`) ON DELETE CASCADE;

--
-- Restrições para tabelas `vendas`
--
ALTER TABLE `vendas`
  ADD CONSTRAINT `vendas_ibfk_1` FOREIGN KEY (`operacao_id`) REFERENCES `operacoes` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `vendas_ibfk_2` FOREIGN KEY (`usuario_id`) REFERENCES `usuarios` (`id`) ON DELETE SET NULL,
  ADD CONSTRAINT `vendas_ibfk_3` FOREIGN KEY (`cliente_id`) REFERENCES `clientes` (`id`) ON DELETE SET NULL;
COMMIT;

/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
