-- Verifica se a coluna status já existe
SET @exists := (
    SELECT COUNT(*)
    FROM information_schema.COLUMNS
    WHERE TABLE_SCHEMA = 'garota'
    AND TABLE_NAME = 'operacoes'
    AND COLUMN_NAME = 'status'
);

-- Se não existir, adiciona a coluna
SET @query := IF(
    @exists = 0,
    'ALTER TABLE operacoes ADD COLUMN status VARCHAR(20) DEFAULT "ativo" AFTER tipo',
    'SELECT "Column status already exists"'
);

PREPARE stmt FROM @query;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;

-- Atualiza registros existentes
UPDATE operacoes SET status = 'ativo' WHERE status IS NULL;
