<?php
require_once 'includes/config.php';

try {
    // Conectar ao MySQL sem selecionar um banco de dados
    $pdo = new PDO("mysql:host=" . DB_HOST, DB_USER, DB_PASS);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

    // Criar o banco de dados se não existir
    $pdo->exec("CREATE DATABASE IF NOT EXISTS " . DB_NAME . " CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci");
    
    // Selecionar o banco de dados
    $pdo->exec("USE " . DB_NAME);

    // Executar o script de instalação completo
    $sql_file = 'sql/full_install.sql';
    if (file_exists($sql_file)) {
        $sql = file_get_contents($sql_file);
        // Dividir o SQL em comandos individuais
        $commands = array_filter(array_map('trim', explode(';', $sql)));
        foreach ($commands as $command) {
            if (!empty($command)) {
                try {
                    $pdo->exec($command);
                } catch (PDOException $e) {
                    // Logar o erro mas continuar a execução
                    error_log("Erro ao executar comando SQL: " . $e->getMessage());
                    error_log("Comando: " . $command);
                }
            }
        }
    }

    // Criar pasta de uploads se não existir
    $upload_dirs = [
        'uploads',
        'uploads/produtos',
        'uploads/marketing'
    ];

    foreach ($upload_dirs as $dir) {
        if (!file_exists($dir)) {
            mkdir($dir, 0777, true);
        }
    }

    // Criar arquivo de instalação
    file_put_contents('installed.txt', date('Y-m-d H:i:s'));

    echo json_encode(['success' => true, 'message' => 'Sistema instalado com sucesso!']);
} catch (PDOException $e) {
    echo json_encode(['success' => false, 'message' => 'Erro na instalação: ' . $e->getMessage()]);
}
