<?php
require_once 'includes/header.php';
require_once 'config/database.php';
?>

<div class="wrapper">
    <!-- Sidebar -->
    <?php require_once 'includes/sidebar.php'; ?>

    <!-- Content -->
    <div id="content">
        <!-- Navbar -->
        <nav class="navbar navbar-expand-lg bg-white">
            <div class="container-fluid">
                <h2 class="navbar-title">Detalhes da Prova</h2>
                <div class="ms-auto">
                    <button type="button" class="btn btn-success" id="btnFinalizarAgora">
                        <i class="bi bi-check2-circle"></i> Finalizar Agora
                    </button>
                    <a href="provas.php" class="btn btn-outline-secondary">
                        <i class="bi bi-arrow-left"></i> Voltar
                    </a>
                </div>
            </div>
        </nav>

        <div class="container-fluid">
            <!-- Detalhes da Prova -->
            <div class="row mb-4">
                <div class="col-md-12">
                    <div class="card">
                        <div class="card-body">
                            <div class="row">
                                <div class="col-md-4">
                                    <p><strong>Cliente:</strong> <span id="clienteNome"></span></p>
                                </div>
                                <div class="col-md-4">
                                    <p><strong>Data:</strong> <span id="provaData"></span></p>
                                </div>
                                <div class="col-md-4">
                                    <p><strong>Valor Total:</strong> <span id="provaValorTotal"></span></p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Itens da Prova -->
            <div class="row">
                <div class="col-12">
                    <div class="card">
                        <div class="card-body">
                            <div class="table-responsive">
                                <table class="table table-striped table-hover">
                                    <thead>
                                        <tr>
                                            <th>Produto</th>
                                            <th>Tamanho</th>
                                            <th>Quantidade</th>
                                            <th>Valor Unitário</th>
                                            <th>Subtotal</th>
                                        </tr>
                                    </thead>
                                    <tbody id="itensProvaTableBody">
                                        <!-- Dados serão carregados via JavaScript -->
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Toast Container -->
<div class="toast-container position-fixed bottom-0 end-0 p-3"></div>

<!-- Scripts -->
<script src="assets/js/prova.js"></script>
<script src="assets/js/toast.js"></script>

<?php require_once 'includes/footer.php'; ?>
