<?php
require_once 'includes/verificar_permissao.php';
verificarPermissao(__FILE__);
?>
<?php
$pageTitle = "Produtos";
require_once 'includes/header.php';
?>

<div class="wrapper">
    <!-- Sidebar -->
    <?php require_once 'includes/sidebar.php'; ?>

    <!-- Page Content -->
    <div id="content">
        <!-- Navbar -->
        <nav class="navbar navbar-expand-lg bg-white">
            <div class="container-fluid">
                <h2 class="navbar-title">Produtos</h2>
                <div class="ms-auto">
                    <button type="button" class="btn btn-primary me-2" data-bs-toggle="modal" data-bs-target="#modalProduto">
                        <i class="bi bi-plus-lg"></i> Cadastrar Produto
                    </button>
                    <button type="button" class="btn btn-secondary" data-bs-toggle="modal" data-bs-target="#modalCategoria">
                        <i class="bi bi-folder-plus"></i> Cadastrar Categoria
                    </button>
                </div>
            </div>
        </nav>

        <!-- Main Content -->
        <div class="container-fluid content-area">
            <div class="row">
                <!-- Lista de Produtos -->
                <div class="col-lg-9">
                    <div class="card">
                        <div class="card-body">
                            <table id="tabelaProdutos" class="table table-striped">
                                <thead>
                                    <tr>
                                        <th>Imagem</th>
                                        <th>Nome</th>
                                        <th>Categoria</th>
                                        <th>Cor</th>
                                        <th>Valor</th>
                                        <th>Estoque Total</th>
                                        <th>Ações</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <!-- Preenchido via JavaScript -->
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>

                <!-- Lista de Categorias -->
                <div class="col-lg-3">
                    <div class="card">
                        <div class="card-header">
                            <h5 class="card-title mb-0" style="color: var(--cor-terciaria);">Categorias Cadastradas</h5>
                        </div>
                        <div class="card-body">
                            <table id="tabelaCategorias" class="table">
                                <thead>
                                    <tr>
                                        <th>Nome</th>
                                        <th>Ações</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <!-- Preenchido via JavaScript -->
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Modal Cadastro de Produto -->
<div class="modal fade" id="modalProduto" tabindex="-1">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Cadastrar Produto</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <form id="formProduto" enctype="multipart/form-data">
                    <input type="hidden" name="id">
                    <div class="mb-3">
                        <label class="form-label">Nome do Produto</label>
                        <input type="text" class="form-control" name="nome" required>
                    </div>

                    <div class="mb-3">
                        <label class="form-label">Código de Barras</label>
                        <input type="text" class="form-control" name="codigo_barras" placeholder="Digite ou use um leitor de código de barras">
                    </div>

                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label class="form-label">Categoria</label>
                                <select class="form-select" name="categoria_id" required>
                                    <option value="">Selecione uma categoria</option>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label class="form-label">Cor</label>
                                <input type="text" class="form-control" name="cor" required>
                            </div>
                        </div>
                    </div>

                    <div id="tamanhos-container">
                        <h6 class="mb-3" style="color: var(--cor-texto);">Tamanhos e Estoque</h6>
                        <div class="tamanho-item mb-2">
                            <div class="row">
                                <div class="col-md-6">
                                    <input type="text" class="form-control" name="tamanhos[]" placeholder="Tamanho" required>
                                </div>
                                <div class="col-md-5">
                                    <input type="number" class="form-control" name="estoques[]" placeholder="Quantidade" required min="0">
                                </div>
                                <div class="col-md-1">
                                    <button type="button" class="btn btn-danger btn-sm remover-tamanho">
                                        <i class="bi bi-trash"></i>
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>

                    <button type="button" class="btn btn-outline-primary btn-sm mt-2 mb-3" id="addTamanho">
                        <i class="bi bi-plus-lg"></i> Adicionar Tamanho
                    </button>

                    <div class="mb-3">
                        <label class="form-label">Valor</label>
                        <div class="input-group">
                            <span class="input-group-text">R$</span>
                            <input type="text" class="form-control money" name="valor" required>
                        </div>
                    </div>

                    <div class="mb-3">
                        <label class="form-label">Imagem do Produto</label>
                        <input type="file" class="form-control" name="imagem" accept="image/*">
                        <small class="text-muted">Deixe em branco para manter a imagem atual</small>
                    </div>
                </form>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
                <button type="submit" form="formProduto" class="btn btn-primary">Salvar</button>
            </div>
        </div>
    </div>
</div>

<!-- Modal Cadastro de Categoria -->
<div class="modal fade" id="modalCategoria" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Cadastrar Categoria</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <form id="formCategoria">
                    <div class="mb-3">
                        <label class="form-label">Nome da Categoria</label>
                        <input type="text" class="form-control" name="nome" required>
                    </div>
                </form>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
                <button type="submit" form="formCategoria" class="btn btn-primary">Salvar</button>
            </div>
        </div>
    </div>
</div>

<!-- Modal Editar Categoria -->
<div class="modal fade" id="modalEditarCategoria" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Editar Categoria</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <form id="formEditarCategoria">
                    <input type="hidden" name="id">
                    <div class="mb-3">
                        <label class="form-label">Nome da Categoria</label>
                        <input type="text" class="form-control" name="nome" required>
                    </div>
                </form>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
                <button type="submit" form="formEditarCategoria" class="btn btn-primary">Salvar</button>
            </div>
        </div>
    </div>
</div>

<!-- DataTables -->
<link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/1.13.7/css/dataTables.bootstrap5.min.css">
<script type="text/javascript" src="https://cdn.datatables.net/1.13.7/js/jquery.dataTables.min.js"></script>
<script type="text/javascript" src="https://cdn.datatables.net/1.13.7/js/dataTables.bootstrap5.min.js"></script>

<!-- jQuery Mask -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery.mask/1.14.16/jquery.mask.min.js"></script>

<!-- Scripts -->
<script src="assets/js/produtos.js"></script>

<!-- Modal de Exclusão -->
<div class="modal fade" id="modalExcluir" tabindex="-1" aria-labelledby="modalExcluirLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="modalExcluirLabel">Confirmar Exclusão</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <p>Tem certeza que deseja excluir este produto?</p>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
                <button type="button" class="btn btn-danger" id="confirmar-exclusao">Excluir</button>
            </div>
        </div>
    </div>
</div>
<!-- Modal de Exclusão de Categoria -->
<div class="modal fade" id="modalExcluirCategoria" tabindex="-1" aria-labelledby="modalExcluirCategoriaLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="modalExcluirCategoriaLabel">Confirmar Exclusão</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <p>Tem certeza que deseja excluir esta categoria?</p>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
                <button type="button" class="btn btn-danger" id="confirmar-exclusao-categoria">Excluir</button>
            </div>
        </div>
    </div>
</div>
<?php require_once 'includes/footer.php'; ?>
