<?php
require_once 'includes/verificar_permissao.php';
verificarPermissao(__FILE__);
?>
<?php
require_once 'includes/config.php';
require_once 'includes/auth.php';

$pageTitle = "PDV";
include 'includes/header.php';
?>
<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>PDV - Garota Bonita</title>
    <link rel="icon" type="image/png" href="favicon.png">
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <!-- Bootstrap Icons -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css">
    <!-- Select2 -->
    <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
    <link href="https://cdn.jsdelivr.net/npm/select2-bootstrap-5-theme@1.3.0/dist/select2-bootstrap-5-theme.min.css" rel="stylesheet" />
    <!-- Google Fonts - Poppins -->
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <!-- Custom CSS -->
    <link rel="stylesheet" href="assets/css/theme.css?v=<?php echo time(); ?>">
    <link rel="stylesheet" href="assets/css/style.css?v=<?php echo time(); ?>">
    <link rel="stylesheet" href="assets/css/pdv.css?v=<?php echo time(); ?>">
    <!-- SweetAlert2 -->
    <link href="https://cdn.jsdelivr.net/npm/sweetalert2@11.10.1/dist/sweetalert2.min.css" rel="stylesheet">
</head>
<body>
    <div class="wrapper pdv-page">
        <!-- Sidebar -->
    <?php require_once 'includes/sidebar.php'; ?>

    <!-- Page Content -->
    <div id="content">
        <!-- Navbar -->
        <nav class="navbar navbar-expand-lg bg-white">
            <div class="container-fluid">
                <h2 class="navbar-title">PDV</h2>
                <div class="ms-auto">
            </div>
        </nav>

            <div class="container-fluid content-area">
                <div class="row">
                    <!-- Área de Seleção -->
                    <div class="col-md-8">
                        <div class="card mb-3">
                            <div class="card-body">
                                <div class="row">
                                    <div class="col-md-6 mb-3">
                                        <label class="form-label">Cliente</label>
                                        <select class="form-select select2" id="cliente">
                                            <option value="">Selecione um cliente</option>
                                        </select>
                                    </div>
                                    <div class="col-md-6 mb-3">
                                        <label class="form-label">Tipo de Operação</label>
                                        <select class="form-select" id="tipoOperacao">
                                            <option value="venda">Venda</option>
                                            <option value="prova">Prova</option>
                                        </select>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="card">
                            <div class="card-body">
                                <div class="row mb-3">
                                    <div class="col-md-12">
                                        <label class="form-label">Produto</label>
                                        <select class="form-select select2" id="produto">
                                            <option value="">Selecione um produto</option>
                                        </select>
                                    </div>
                                </div>
                                <div class="row mb-3">
                                    <div class="col-md-6">
                                        <label class="form-label">Tamanho</label>
                                        <select class="form-select" id="tamanho" disabled>
                                            <option value="">Selecione um tamanho</option>
                                        </select>
                                    </div>
                                    <div class="col-md-6">
                                        <label class="form-label">Quantidade</label>
                                        <input type="number" class="form-control" id="quantidade" value="1" min="1" disabled>
                                    </div>
                                </div>
                                <div class="text-end">
                                    <button class="btn btn-primary" id="adicionarProduto" disabled>
                                        <i class="bi bi-plus-lg"></i> Adicionar
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Cupom Fiscal -->
                    <div class="col-md-4">
                        <div class="card cupom-fiscal">
                            <div class="card-body">
                                <h5 class="text-center mb-3">Cupom Fiscal</h5>
                                <div class="cupom-header mb-3">
                                    <div id="clienteInfo">Selecione um cliente</div>
                                    <div id="operacaoInfo">Venda</div>
                                    <div id="dataHora"></div>
                                </div>
                                <div class="cupom-items" id="cupomItems">
                                    <!-- Items serão adicionados aqui -->
                                </div>
                                <div class="cupom-total">
                                    <div class="d-flex justify-content-between">
                                        <strong>Total:</strong>
                                        <strong id="totalValue">R$ 0,00</strong>
                                    </div>
                                </div>
                                <div id="metodoPagamentoContainer" class="mt-3">
                                    <div class="mb-3">
                                        <label for="metodoPagamento" class="form-label">Método de Pagamento</label>
                                        <select class="form-select" id="metodoPagamento" name="metodoPagamento">
                                            <option value="">Selecione...</option>
                                            <option value="dinheiro">Dinheiro</option>
                                            <option value="credito">Cartão de Crédito</option>
                                            <option value="debito">Cartão de Débito</option>
                                            <option value="pix">PIX</option>
                                            <option value="crediario" data-bs-toggle="tooltip" title="Não entrará dinheiro no caixa, apenas saída do estoque">Crediário</option>
                                        </select>
                                        <small class="text-muted" id="crediarioInfo" style="display: none;">
                                            * Crediário: Não entrará dinheiro no caixa, apenas saída do estoque
                                        </small>
                                    </div>
                                    <div id="dinheiroContainer" class="mb-3" style="display: none;">
                                        <label class="form-label">Valor Recebido</label>
                                        <input type="text" class="form-control" id="valorRecebido" placeholder="0,00">
                                        <div id="trocoContainer" class="mt-2" style="display: none;">
                                            <div class="alert alert-info mb-0">
                                                <strong>Troco:</strong> <span id="trocoValue">R$ 0,00</span>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="mt-3">
                                    <button class="btn btn-success w-100 mb-2" id="btnFinalizar">
                                        Finalizar Venda
                                    </button>
                                    <button class="btn btn-outline-secondary w-100" id="btnCancelar">
                                        Cancelar
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Toast Container -->
    <div class="toast-container position-fixed bottom-0 end-0 p-3"></div>

    <!-- Scripts -->
    <script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
    <script src="assets/js/sidebar.js"></script>
    <script src="assets/js/toast.js"></script>
    <script src="assets/js/pdv.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11.10.1/dist/sweetalert2.min.js"></script>    
</body>
</html>
