<?php
$pageTitle = "Upload de Logo";
require_once '../includes/header.php';
?>

<div class="container mt-4">
    <div class="row">
        <div class="col-md-6 offset-md-3">
            <div class="card">
                <div class="card-header">
                    <h5 class="card-title mb-0">Upload de Logo</h5>
                </div>
                <div class="card-body">
                    <form id="logoForm" enctype="multipart/form-data">
                        <div class="mb-3">
                            <label for="logo" class="form-label">Selecione a Logo</label>
                            <input type="file" class="form-control" id="logo" name="logo" accept="image/*" required>
                            <div class="form-text">Formatos aceitos: JPG, JPEG, PNG, GIF. Tamanho máximo: 2MB</div>
                        </div>
                        <div id="preview" class="text-center mb-3" style="display: none;">
                            <img id="logoPreview" src="#" alt="Preview da Logo" style="max-height: 150px;">
                        </div>
                        <button type="submit" class="btn btn-primary">Enviar Logo</button>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
document.getElementById('logo').onchange = function(e) {
    const preview = document.getElementById('preview');
    const logoPreview = document.getElementById('logoPreview');
    const file = e.target.files[0];
    
    if (file) {
        const reader = new FileReader();
        reader.onload = function(e) {
            logoPreview.src = e.target.result;
            preview.style.display = 'block';
        }
        reader.readAsDataURL(file);
    }
};

document.getElementById('logoForm').onsubmit = function(e) {
    e.preventDefault();
    
    const formData = new FormData(this);
    
    fetch('../actions/upload_logo.php', {
        method: 'POST',
        body: formData
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            alert('Logo atualizada com sucesso!');
            window.location.reload();
        } else {
            alert('Erro: ' + data.message);
        }
    })
    .catch(error => {
        console.error('Erro:', error);
        alert('Erro ao enviar a logo');
    });
};
</script>

<?php require_once '../includes/footer.php'; ?>
