<?php
// Verificar se o sistema está instalado
if (!file_exists('installed.txt')) {
    header('Location: install.php');
    exit;
}

require_once 'includes/config.php';
require_once 'includes/auth.php';
require_once 'includes/conexao.php';

// Buscar valor em caixa
$valor_em_caixa = 0;
$stmt = $pdo->prepare("SELECT id, valor_abertura, data_abertura FROM caixa WHERE status = 'aberto' ORDER BY id DESC LIMIT 1");
$stmt->execute();
$caixa_atual = $stmt->fetch(PDO::FETCH_ASSOC);

if ($caixa_atual) {
    $valor_em_caixa = $caixa_atual['valor_abertura'];
    
    // Debug: Mostrar a data de abertura do caixa
    echo "<!-- Data abertura: " . $caixa_atual['data_abertura'] . " -->";
    
    // Somar vendas desde a abertura do caixa (apenas vendas que afetam o caixa)
    $stmt = $pdo->prepare("
        SELECT COALESCE(SUM(v.valor_total), 0) as total_vendas, COUNT(*) as num_vendas
        FROM vendas v
        INNER JOIN operacoes o ON v.operacao_id = o.id
        WHERE v.data_venda >= ? 
        AND o.afeta_caixa = 1
    ");
    $stmt->execute([$caixa_atual['data_abertura']]);
    $total_vendas = $stmt->fetch(PDO::FETCH_ASSOC);
    $valor_em_caixa += $total_vendas['total_vendas'];
    
    // Debug: Mostrar total de vendas encontradas
    echo "<!-- Número de vendas: " . $total_vendas['num_vendas'] . " -->";
    echo "<!-- Total vendas: " . $total_vendas['total_vendas'] . " -->";

    // Somar recebimentos do crediário desde a abertura do caixa
    $stmt = $pdo->prepare("
        SELECT COALESCE(SUM(valor_pago), 0) as total_crediario, COUNT(*) as num_pagamentos
        FROM pagamentos_crediario 
        WHERE data_pagamento >= ?
    ");
    $stmt->execute([$caixa_atual['data_abertura']]);
    $total_crediario = $stmt->fetch(PDO::FETCH_ASSOC);
    $valor_em_caixa += $total_crediario['total_crediario'];
    
    // Debug: Mostrar total de pagamentos encontrados
    echo "<!-- Número de pagamentos: " . $total_crediario['num_pagamentos'] . " -->";
    echo "<!-- Total crediário: " . $total_crediario['total_crediario'] . " -->";
}

$pageTitle = "Dashboard";
require_once 'includes/header.php';
?>

<div class="wrapper">
    <!-- Sidebar -->
    <?php require_once 'includes/sidebar.php'; ?>

    <!-- Page Content -->
    <div id="content">
        <!-- Navbar -->
        <nav class="navbar navbar-expand-lg bg-white">
            <div class="container-fluid">
                <h2 class="navbar-title">Dashboard</h2>
                <div class="ms-auto">
            </div>
        </nav>

        <!-- Main Content -->
        <div class="container-fluid content-area">
            <div class="row">
                <!-- Valor em Caixa -->
                <div class="col-md-3">
                    <div class="card dashboard-card">
                        <div class="card-body">
                            <h5 class="card-title">Valor em Caixa</h5>
                            <p class="card-text" id="valorCaixa">R$ <?php echo number_format($valor_em_caixa, 2, ',', '.'); ?></p>
                            <i class="bi bi-cash-stack"></i>
                        </div>
                    </div>
                </div>

                <!-- Provas Pendentes -->
                <div class="col-md-3">
                    <div class="card dashboard-card">
                        <div class="card-body">
                            <h5 class="card-title">Provas Pendentes</h5>
                            <p class="card-text" id="totalProvas">0</p>
                            <i class="bi bi-list-check"></i>
                        </div>
                    </div>
                </div>

                <!-- Clientes Cadastrados -->
                <div class="col-md-3">
                    <div class="card dashboard-card">
                        <div class="card-body">
                            <h5 class="card-title">Clientes Cadastrados</h5>
                            <p class="card-text" id="totalClientes">0</p>
                            <i class="bi bi-people"></i>
                        </div>
                    </div>
                </div>

                <!-- Produtos Cadastrados -->
                <div class="col-md-3">
                    <div class="card dashboard-card">
                        <div class="card-body">
                            <h5 class="card-title">Produtos Cadastrados</h5>
                            <p class="card-text" id="totalProdutos">0</p>
                            <i class="bi bi-box-seam"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Scripts -->
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="assets/js/main.js"></script>
<script src="assets/js/dashboard.js"></script>

</body>
</html>
