<?php
$currentPage = basename($_SERVER['PHP_SELF']);

// Busca a logo da empresa
require_once dirname(__DIR__) . '/config/database.php';
$database = new Database();
$db = $database->getConnection();

$logo_path = null;
$empresa_nome = 'Sistema';

try {
    $query = "SELECT logo, nome_empresa FROM config_empresa WHERE id = 1";
    $stmt = $db->prepare($query);
    if ($stmt->execute()) {
        $result = $stmt->fetch(PDO::FETCH_ASSOC);
        if ($result && !empty($result['logo'])) {
            $logo_path = $result['logo'];
        }
        if ($result && !empty($result['nome_empresa'])) {
            $empresa_nome = $result['nome_empresa'];
        }
    }
} catch (Exception $e) {
    error_log("Erro ao buscar dados da empresa: " . $e->getMessage());
}

// Se não houver logo no banco, usa o placeholder
if (empty($logo_path)) {
    $logo_path = 'assets/img/placeholder-logo.png';
}

// Determina o caminho base correto
$script_path = $_SERVER['SCRIPT_NAME'];
$base_path = '';

// Se estamos em um subdiretório, precisamos voltar um nível
if (strpos($script_path, '/pages/') !== false || 
    strpos($script_path, '/includes/') !== false || 
    strpos($script_path, '\\pages\\') !== false || 
    strpos($script_path, '\\includes\\') !== false) {
    $base_path = '../';
}

$full_logo_path = $base_path . $logo_path;

// Debug das permissões
error_log("DEBUG - Usuário logado: " . (isset($_SESSION['usuario_nome']) ? $_SESSION['usuario_nome'] : 'Nenhum'));
error_log("DEBUG - Permissões do usuário: " . (isset($_SESSION['permissoes']) ? json_encode($_SESSION['permissoes']) : 'Nenhuma'));

// Função para verificar se o usuário tem permissão
function temPermissao($permissao) {
    // Se for admin, tem todas as permissões
    if (isset($_SESSION['admin']) && $_SESSION['admin'] === true) {
        error_log("DEBUG - Usuário é admin, permissão concedida para: " . $permissao);
        return true;
    }

    // Verifica se existem permissões definidas na sessão
    if (!isset($_SESSION['permissoes']) || !is_array($_SESSION['permissoes'])) {
        error_log("DEBUG - Nenhuma permissão encontrada na sessão");
        return false;
    }

    // Verifica se o usuário tem a permissão específica
    $tem_permissao = in_array($permissao, $_SESSION['permissoes']);
    error_log("DEBUG - Verificando permissão '$permissao': " . ($tem_permissao ? 'Sim' : 'Não'));
    return $tem_permissao;
}

// Se for admin, tem todas as permissões
if (isset($_SESSION['usuario_nome']) && strtolower($_SESSION['usuario_nome']) === 'admin') {
    $_SESSION['permissoes'] = ['dashboard', 'clientes', 'produtos', 'pdv', 'caixa', 'vendas', 'provas', 'relatorios', 'usuarios', 'configuracoes'];
    error_log("DEBUG - Permissões de admin atualizadas: " . json_encode($_SESSION['permissoes']));
}
?>

<nav id="sidebar" class="active">
    <div class="d-flex flex-column h-100"> 
        <div class="sidebar-header">
            <div class="logo-container">
                <img src="<?php echo htmlspecialchars($full_logo_path); ?>" 
                     alt="<?php echo htmlspecialchars($empresa_nome); ?>" 
                     class="sidebar-logo"
                     onerror="this.src='<?php echo $base_path; ?>assets/img/placeholder-logo.png'"
                     onload="this.classList.add('loaded')">
            </div>
        </div>

        <div class="menu-container flex-grow-1">
            <ul class="list-unstyled components">
                <?php if (temPermissao('dashboard')): ?>
                <li class="<?php echo $currentPage == 'index.php' ? 'active' : ''; ?>">
                    <a href="<?php echo $base_path; ?>index.php">
                        <i class="bi bi-speedometer2"></i>
                        Dashboard
                    </a>
                </li>
                <?php endif; ?>

                <?php if (temPermissao('clientes')): ?>
                <li class="<?php echo $currentPage == 'clientes.php' ? 'active' : ''; ?>">
                    <a href="<?php echo $base_path; ?>clientes.php">
                        <i class="bi bi-people"></i>
                        Clientes
                    </a>
                </li>
                <?php endif; ?>

                <?php if (temPermissao('produtos')): ?>
                <li class="<?php echo $currentPage == 'produtos.php' ? 'active' : ''; ?>">
                    <a href="<?php echo $base_path; ?>produtos.php">
                        <i class="bi bi-box-seam"></i>
                        Produtos
                    </a>
                </li>
                <?php endif; ?>

                <?php if (temPermissao('pdv')): ?>
                <li class="<?php echo $currentPage == 'pdv.php' ? 'active' : ''; ?>">
                    <a href="<?php echo $base_path; ?>pdv.php">
                        <i class="bi bi-cart3"></i>
                        PDV
                    </a>
                </li>
                <?php endif; ?>

                <?php if (temPermissao('caixa')): ?>
                <li class="<?php echo $currentPage == 'caixa.php' ? 'active' : ''; ?>">
                    <a href="<?php echo $base_path; ?>caixa.php">
                        <i class="bi bi-cash-stack"></i>
                        Caixa
                    </a>
                </li>
                <?php endif; ?>

                <?php if (temPermissao('vendas')): ?>
                <li class="<?php echo $currentPage == 'vendas.php' ? 'active' : ''; ?>">
                    <a href="<?php echo $base_path; ?>vendas.php">
                        <i class="bi bi-receipt"></i>
                        Vendas
                    </a>
                </li>
                <?php endif; ?>

                <?php if (temPermissao('provas')): ?>
                <li class="<?php echo $currentPage == 'provas.php' ? 'active' : ''; ?>">
                    <a href="<?php echo $base_path; ?>provas.php">
                        <i class="bi bi-arrow-repeat"></i>
                        Provas
                    </a>
                </li>
                <?php endif; ?>

                <?php if (temPermissao('relatorios')): ?>
                <li class="<?php echo $currentPage == 'relatorios.php' ? 'active' : ''; ?>">
                    <a href="<?php echo $base_path; ?>relatorios.php">
                        <i class="bi bi-file-earmark-text"></i>
                        Relatórios
                    </a>
                </li>
                <?php endif; ?>

                <?php if (temPermissao('usuarios')): ?>
                <li class="<?php echo $currentPage == 'usuarios.php' ? 'active' : ''; ?>">
                    <a href="<?php echo $base_path; ?>usuarios.php">
                        <i class="bi bi-people"></i>
                        Usuários
                    </a>
                </li>
                <?php endif; ?>

                <?php if (temPermissao('configuracoes')): ?>
                <li class="<?php echo $currentPage == 'configuracoes.php' ? 'active' : ''; ?>">
                    <a href="<?php echo $base_path; ?>configuracoes.php">
                        <i class="bi bi-gear"></i>
                        Configurações
                    </a>
                </li>
                <?php endif; ?>
            </ul>
        </div>

        <!-- Botão de Sair -->
        <div class="sidebar-footer">
            <ul class="list-unstyled">
                <li>
                    <a href="<?php echo $base_path; ?>actions/logout.php" class="btn-sair">
                        <i class="bi bi-box-arrow-right"></i>
                        Sair
                    </a>
                </li>
            </ul>
        </div>
    </div>
</nav>
