<?php
require_once __DIR__ . '/../config/database.php';

try {
    $database = new Database();
    $db = $database->getConnection();

    // 1. Recriar tabela config_estilo_cores
    $sql_drop = "DROP TABLE IF EXISTS config_estilo_cores";
    $db->exec($sql_drop);

    $sql_create = "CREATE TABLE config_estilo_cores (
        id INT AUTO_INCREMENT PRIMARY KEY,
        cor_principal VARCHAR(7) DEFAULT '#1923ae',
        cor_secundaria VARCHAR(7) DEFAULT '#b88700',
        cor_terciaria VARCHAR(7) DEFAULT '#166053',
        cor_texto VARCHAR(7) DEFAULT '#166053',
        created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
        updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
    )";
    $db->exec($sql_create);

    // Inserir valores padrão
    $sql_insert = "INSERT INTO config_estilo_cores 
                  (cor_principal, cor_secundaria, cor_terciaria, cor_texto)
                  VALUES 
                  ('#1923ae', '#b88700', '#166053', '#166053')";
    $db->exec($sql_insert);

    // 2. Recriar tabela de redes sociais com apenas as colunas necessárias
    $sql_drop_redes = "DROP TABLE IF EXISTS config_redes_sociais";
    $db->exec($sql_drop_redes);

    $sql_create_redes = "CREATE TABLE config_redes_sociais (
        id INT AUTO_INCREMENT PRIMARY KEY,
        facebook VARCHAR(255) DEFAULT '',
        instagram VARCHAR(255) DEFAULT '',
        tiktok VARCHAR(255) DEFAULT '',
        linkedin VARCHAR(255) DEFAULT '',
        created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
        updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
    )";
    $db->exec($sql_create_redes);

    // Inserir registro inicial vazio
    $sql_insert_redes = "INSERT INTO config_redes_sociais 
                        (facebook, instagram, tiktok, linkedin)
                        VALUES 
                        ('', '', '', '')";
    $db->exec($sql_insert_redes);

    echo "Tabelas atualizadas com sucesso!";

} catch(PDOException $e) {
    error_log("Erro: " . $e->getMessage());
    echo "Erro ao atualizar tabelas: " . $e->getMessage();
}
?>
