<?php
require_once __DIR__ . '/../config/database.php';

try {
    $database = new Database();
    $db = $database->getConnection();

    // Verificar se a coluna cor_texto existe
    $check_column = "SHOW COLUMNS FROM config_empresa LIKE 'cor_texto'";
    $result = $db->query($check_column);
    
    if ($result->rowCount() == 0) {
        // Adicionar a coluna cor_texto se não existir
        $add_column = "ALTER TABLE config_empresa ADD COLUMN cor_texto VARCHAR(7) DEFAULT '#166053'";
        $db->exec($add_column);
        echo "Coluna cor_texto adicionada com sucesso!\n";
    }

    // Verificar se há registros na tabela
    $check_records = "SELECT COUNT(*) FROM config_empresa";
    $count = $db->query($check_records)->fetchColumn();

    if ($count == 0) {
        // Inserir valores padrão
        $insert = "INSERT INTO config_empresa (cor_principal, cor_secundaria, cor_texto) 
                  VALUES ('#1923ae', '#b88700', '#166053')";
        $db->exec($insert);
        echo "Valores padrão inseridos com sucesso!\n";
    }

    echo "Tabela de configurações atualizada com sucesso!";

} catch(PDOException $e) {
    error_log("Erro ao atualizar tabela: " . $e->getMessage());
    echo "Erro ao atualizar tabela de configurações: " . $e->getMessage();
}
?>
