<?php
require_once __DIR__ . '/../config/database.php';

try {
    $database = new Database();
    $db = $database->getConnection();

    // Criar tabela de histórico de configurações
    $query = "CREATE TABLE IF NOT EXISTS config_history (
        id INT AUTO_INCREMENT PRIMARY KEY,
        config_type VARCHAR(50) NOT NULL,
        config_data TEXT NOT NULL,
        user_id INT,
        created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
        description TEXT,
        ip_address VARCHAR(45),
        revert_hash VARCHAR(32)
    )";

    $db->exec($query);
    echo "Tabela config_history criada com sucesso!\n";

} catch(PDOException $e) {
    echo "Erro ao criar tabela: " . $e->getMessage() . "\n";
}
?>
