<?php
require_once __DIR__ . '/../config/database.php';

try {
    $database = new Database();
    $db = $database->getConnection();

    // Criar nova tabela config_estilo_cores
    $sql_create = "CREATE TABLE IF NOT EXISTS config_estilo_cores (
        id INT AUTO_INCREMENT PRIMARY KEY,
        cor_principal VARCHAR(7) DEFAULT '#1923ae',
        cor_secundaria VARCHAR(7) DEFAULT '#b88700',
        cor_terciaria VARCHAR(7) DEFAULT '#166053',
        cor_texto VARCHAR(7) DEFAULT '#166053',
        created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
        updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
    )";
    $db->exec($sql_create);

    // Copiar dados da tabela config_empresa
    $sql_select = "SELECT cor_principal, cor_secundaria, cor_terciaria, cor_texto 
                  FROM config_empresa 
                  WHERE id = 1";
    $stmt = $db->query($sql_select);
    $cores = $stmt->fetch(PDO::FETCH_ASSOC);

    if ($cores) {
        // Inserir cores na nova tabela
        $sql_insert = "INSERT INTO config_estilo_cores 
                      (cor_principal, cor_secundaria, cor_terciaria, cor_texto)
                      VALUES 
                      (:cor_principal, :cor_secundaria, :cor_terciaria, :cor_texto)";
        $stmt = $db->prepare($sql_insert);
        $stmt->execute([
            'cor_principal' => $cores['cor_principal'] ?: '#1923ae',
            'cor_secundaria' => $cores['cor_secundaria'] ?: '#b88700',
            'cor_terciaria' => $cores['cor_terciaria'] ?: '#166053',
            'cor_texto' => $cores['cor_texto'] ?: '#166053'
        ]);
    } else {
        // Inserir valores padrão
        $sql_default = "INSERT INTO config_estilo_cores 
                       (cor_principal, cor_secundaria, cor_terciaria, cor_texto)
                       VALUES 
                       ('#1923ae', '#b88700', '#166053', '#166053')";
        $db->exec($sql_default);
    }

    // Remover colunas de cores da tabela config_empresa
    $sql_alter = "ALTER TABLE config_empresa 
                 DROP COLUMN cor_principal,
                 DROP COLUMN cor_secundaria,
                 DROP COLUMN cor_terciaria,
                 DROP COLUMN cor_texto";
    $db->exec($sql_alter);

    echo "Tabela config_estilo_cores criada e dados migrados com sucesso!";

} catch(PDOException $e) {
    error_log("Erro: " . $e->getMessage());
    echo "Erro ao criar tabela e migrar dados: " . $e->getMessage();
}
?>
