<?php
// Verifica se o script está sendo executado pelo navegador
if (php_sapi_name() !== 'cli') {
    // Adiciona proteção básica - apenas localhost pode executar
    if ($_SERVER['REMOTE_ADDR'] !== '127.0.0.1' && $_SERVER['REMOTE_ADDR'] !== '::1') {
        die('Este script só pode ser executado localmente.');
    }
}

require_once __DIR__ . '/../config/database.php';

try {
    $database = new Database();
    $db = $database->getConnection();

    // 1. Recriar tabela de redes sociais com apenas as colunas necessárias
    $sql_drop_redes = "DROP TABLE IF EXISTS config_redes_sociais";
    $db->exec($sql_drop_redes);

    $sql_create_redes = "CREATE TABLE config_redes_sociais (
        id INT AUTO_INCREMENT PRIMARY KEY,
        facebook VARCHAR(255) DEFAULT '',
        instagram VARCHAR(255) DEFAULT '',
        tiktok VARCHAR(255) DEFAULT '',
        linkedin VARCHAR(255) DEFAULT '',
        created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
        updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
    )";
    $db->exec($sql_create_redes);

    // Inserir registro inicial vazio
    $sql_insert_redes = "INSERT INTO config_redes_sociais 
                        (facebook, instagram, tiktok, linkedin)
                        VALUES 
                        ('', '', '', '')";
    $db->exec($sql_insert_redes);

    echo '<div style="font-family: Arial, sans-serif; max-width: 600px; margin: 50px auto; padding: 20px; border: 1px solid #ddd; border-radius: 5px;">';
    echo '<h2 style="color: #28a745;">✅ Tabelas atualizadas com sucesso!</h2>';
    echo '<p>A tabela de redes sociais foi atualizada para incluir apenas:</p>';
    echo '<ul>';
    echo '<li>Facebook</li>';
    echo '<li>Instagram</li>';
    echo '<li>TikTok</li>';
    echo '<li>LinkedIn</li>';
    echo '</ul>';
    echo '<p><a href="../configuracoes.php" style="display: inline-block; padding: 10px 20px; background-color: #007bff; color: white; text-decoration: none; border-radius: 5px;">Voltar para Configurações</a></p>';
    echo '</div>';

} catch(PDOException $e) {
    echo '<div style="font-family: Arial, sans-serif; max-width: 600px; margin: 50px auto; padding: 20px; border: 1px solid #dc3545; border-radius: 5px; background-color: #fff;">';
    echo '<h2 style="color: #dc3545;">❌ Erro ao atualizar tabelas</h2>';
    echo '<p>Ocorreu um erro ao tentar atualizar as tabelas:</p>';
    echo '<pre style="background-color: #f8f9fa; padding: 15px; border-radius: 5px;">';
    echo htmlspecialchars($e->getMessage());
    echo '</pre>';
    echo '<p><a href="../configuracoes.php" style="display: inline-block; padding: 10px 20px; background-color: #007bff; color: white; text-decoration: none; border-radius: 5px;">Voltar para Configurações</a></p>';
    echo '</div>';
}
?>
