<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);

require_once 'includes/config.php';

try {
    $pdo = getConnection();
    
    // Criar tabela pagamentos_parciais
    $sql = "CREATE TABLE IF NOT EXISTS pagamentos_parciais (
        id INT AUTO_INCREMENT PRIMARY KEY,
        venda_id INT NOT NULL,
        valor DECIMAL(10,2) NOT NULL,
        data_pagamento DATETIME NOT NULL,
        FOREIGN KEY (venda_id) REFERENCES operacoes(id)
    )";
    $pdo->exec($sql);
    echo "Tabela pagamentos_parciais criada/verificada com sucesso!<br>";

    // Criar tabela movimentacoes_caixa
    $sql = "CREATE TABLE IF NOT EXISTS movimentacoes_caixa (
        id INT AUTO_INCREMENT PRIMARY KEY,
        tipo ENUM('entrada', 'saida') NOT NULL,
        valor DECIMAL(10,2) NOT NULL,
        data_hora DATETIME NOT NULL,
        descricao TEXT,
        created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
    )";
    $pdo->exec($sql);
    echo "Tabela movimentacoes_caixa criada/verificada com sucesso!<br>";

    // Adicionar coluna status na tabela operacoes se não existir
    $stmt = $pdo->query("SHOW COLUMNS FROM operacoes LIKE 'status'");
    if ($stmt->rowCount() == 0) {
        $sql = "ALTER TABLE operacoes ADD COLUMN status VARCHAR(50) DEFAULT NULL";
        $pdo->exec($sql);
        echo "Coluna status adicionada à tabela operacoes com sucesso!<br>";
    } else {
        echo "Coluna status já existe na tabela operacoes<br>";
    }

} catch (PDOException $e) {
    echo "Erro: " . $e->getMessage();
}
