<?php
require_once 'includes/verificar_permissao.php';
verificarPermissao(__FILE__);
?>
<?php
$pageTitle = "Clientes";
require_once 'includes/header.php';
?>

<div class="wrapper">
    <!-- Sidebar -->
    <?php require_once 'includes/sidebar.php'; ?>

    <div id="content">
        <!-- Navbar -->
        <nav class="navbar navbar-expand-lg bg-white">
            <div class="container-fluid">
                <h2 class="navbar-title">Clientes</h2>
                <div class="ms-auto">
                    <button type="button" class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#modalCadastroCliente">
                        <i class="bi bi-plus-lg"></i> Cadastrar Cliente
                    </button>
                </div>
            </div>
        </nav>

        <div class="container-fluid content-area">
            <!-- Tabela de Clientes -->
            <div class="card">
                <div class="card-body">
                    <div class="table-responsive">
                        <table id="clientesTable" class="table table-striped table-hover">
                            <thead>
                                <tr>
                                    <th>ID</th>
                                    <th>Nome</th>
                                    <th>Data Nasc.</th>
                                    <th>Endereço</th>
                                    <th>Cidade</th>
                                    <th>Telefone</th>
                                    <th>Instagram</th>
                                    <th>Ações</th>
                                </tr>
                            </thead>
                            <tbody>
                                <!-- Dados serão carregados via AJAX -->
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Modal de Cadastro -->
<div class="modal fade" id="modalCadastroCliente" tabindex="-1" aria-labelledby="modalCadastroClienteLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="modalCadastroClienteLabel" style="color: var(--text-color);">Cadastrar Cliente</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <form id="formCadastroCliente">
                <div class="modal-body">
                    <input type="hidden" id="id" name="id">
                    <div class="mb-3">
                        <label for="nome" class="form-label">Nome</label>
                        <input type="text" class="form-control" id="nome" name="nome" required>
                    </div>
                    <div class="mb-3">
                        <label for="data_nascimento" class="form-label">Data de Nascimento</label>
                        <input type="date" class="form-control" id="data_nascimento" name="data_nascimento">
                    </div>
                    <div class="mb-3">
                        <label for="endereco" class="form-label">Endereço</label>
                        <input type="text" class="form-control" id="endereco" name="endereco">
                    </div>
                    <div class="row mb-3">
                        <div class="col-md-4">
                            <label for="numero" class="form-label">Nº</label>
                            <input type="text" class="form-control" id="numero" name="numero">
                        </div>
                        <div class="col-md-8">
                            <label for="bairro" class="form-label">Bairro</label>
                            <input type="text" class="form-control" id="bairro" name="bairro">
                        </div>
                    </div>
                    <div class="mb-3">
                        <label for="cidade" class="form-label">Cidade</label>
                        <input type="text" class="form-control" id="cidade" name="cidade">
                    </div>
                    <div class="mb-3">
                        <label for="telefone" class="form-label">Telefone</label>
                        <input type="text" class="form-control" id="telefone" name="telefone">
                    </div>
                    <div class="mb-3">
                        <label for="instagram" class="form-label">Instagram</label>
                        <div class="input-group">
                            <span class="input-group-text">@</span>
                            <input type="text" class="form-control" id="instagram" name="instagram">
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
                    <button type="submit" class="btn btn-primary">Salvar</button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Script da página -->
<script src="assets/js/clientes.js"></script>

<?php require_once 'includes/footer.php'; ?>
