<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);

require_once 'includes/config.php';

try {
    $pdo = getConnection();
    
    // Verifica se a tabela config_redes_sociais existe
    $stmt = $pdo->query("SHOW TABLES LIKE 'config_redes_sociais'");
    if ($stmt->rowCount() == 0) {
        // Cria a tabela config_redes_sociais
        $sql = "CREATE TABLE config_redes_sociais (
            id INT PRIMARY KEY AUTO_INCREMENT,
            instagram VARCHAR(255),
            facebook VARCHAR(255),
            tiktok VARCHAR(255),
            linkedin VARCHAR(255),
            created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
            updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
        )";
        $pdo->exec($sql);
        
        // Insere um registro vazio
        $pdo->exec("INSERT INTO config_redes_sociais (instagram, facebook, tiktok, linkedin) VALUES ('', '', '', '')");
        
        echo "Tabela config_redes_sociais criada com sucesso!\n";
    }
    
    // Verifica a estrutura da tabela pagamentos_parciais
    echo "<h3>Estrutura da tabela pagamentos_parciais:</h3>";
    $stmt = $pdo->query("SHOW CREATE TABLE pagamentos_parciais");
    $result = $stmt->fetch(PDO::FETCH_ASSOC);
    echo "<pre>";
    print_r($result);
    echo "</pre>";
    
    // Verifica a estrutura da tabela movimentacoes_caixa
    echo "<h3>Estrutura da tabela movimentacoes_caixa:</h3>";
    $stmt = $pdo->query("SHOW CREATE TABLE movimentacoes_caixa");
    $result = $stmt->fetch(PDO::FETCH_ASSOC);
    echo "<pre>";
    print_r($result);
    echo "</pre>";

} catch (PDOException $e) {
    echo "<h3>Erro:</h3>";
    echo "<pre>" . $e->getMessage() . "</pre>";
}
