// Função para mostrar toast
function showToast(message, type = 'success') {
    const toastId = 'toast-' + Date.now();
    const toast = `
        <div class="toast" role="alert" aria-live="assertive" aria-atomic="true" id="${toastId}">
            <div class="toast-header ${type === 'success' ? 'bg-success' : 'bg-danger'} text-white">
                <i class="bi ${type === 'success' ? 'bi-check-circle' : 'bi-exclamation-circle'} me-2"></i>
                <strong class="me-auto">Sistema</strong>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="toast" aria-label="Close"></button>
            </div>
            <div class="toast-body">${message}</div>
        </div>
    `;
    
    $('.toast-container').append(toast);
    const toastElement = new bootstrap.Toast(document.getElementById(toastId), {
        delay: 3000
    });
    toastElement.show();
    
    // Remove o toast do DOM após ser ocultado
    $(`#${toastId}`).on('hidden.bs.toast', function() {
        $(this).remove();
    });
}
