$(document).ready(function() {
    // Variáveis globais para armazenar as instâncias dos gráficos
    let charts = {
        vendasPorPeriodo: null,
        produtosMaisVendidos: null,
        vendasPorPagamento: null,
        melhoresClientes: null
    };

    // Inicializa Select2
    $('.select2').select2({
        theme: 'bootstrap-5',
        width: '100%'
    });

    // Inicializa Daterangepicker
    $('#periodo').daterangepicker({
        locale: {
            format: 'DD/MM/YYYY',
            separator: ' - ',
            applyLabel: 'Aplicar',
            cancelLabel: 'Cancelar',
            fromLabel: 'De',
            toLabel: 'Até',
            customRangeLabel: 'Personalizado',
            weekLabel: 'S',
            daysOfWeek: ['Dom', 'Seg', 'Ter', 'Qua', 'Qui', 'Sex', 'Sáb'],
            monthNames: [
                'Janeiro', 'Fevereiro', 'Março', 'Abril', 'Maio', 'Junho',
                'Julho', 'Agosto', 'Setembro', 'Outubro', 'Novembro', 'Dezembro'
            ],
            firstDay: 0
        },
        startDate: moment().subtract(29, 'days'),
        endDate: moment(),
        ranges: {
            'Hoje': [moment(), moment()],
            'Ontem': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
            'Últimos 7 dias': [moment().subtract(6, 'days'), moment()],
            'Últimos 30 dias': [moment().subtract(29, 'days'), moment()],
            'Este mês': [moment().startOf('month'), moment().endOf('month')],
            'Mês passado': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')]
        }
    });

    // Carrega dados iniciais
    carregarClientes();
    carregarProdutos();
    carregarDados();

    // Event listeners
    $('#btnFiltrar').click(carregarDados);

    // Função para carregar clientes no select
    function carregarClientes() {
        $.get('actions/get_clientes.php', function(response) {
            if (response.success) {
                const select = $('#cliente');
                response.data.forEach(cliente => {
                    select.append(new Option(cliente.nome, cliente.id));
                });
            }
        });
    }

    // Função para carregar produtos no select
    function carregarProdutos() {
        $.get('actions/get_produtos_relatorio.php', function(response) {
            if (response.success) {
                const select = $('#produto');
                select.empty(); // Limpa opções existentes
                select.append(new Option('Todos os produtos', '')); // Adiciona opção padrão
                response.data.forEach(produto => {
                    select.append(new Option(produto.nome, produto.id));
                });
            }
        });
    }

    // Função para carregar todos os dados dos relatórios
    function carregarDados() {
        const filtros = {
            periodo: $('#periodo').val(),
            cliente: $('#cliente').val(),
            produto: $('#produto').val(),
            tipoOperacao: $('#tipoOperacao').val()
        };

        $.get('actions/get_relatorios.php', filtros, function(response) {
            if (response.success) {
                atualizarCards(response.data.resumo);
                atualizarGraficos(response.data.graficos);
            } else {
                showToast('Erro ao carregar dados: ' + response.message, 'error');
            }
        });
    }

    // Função para atualizar os cards de resumo
    function atualizarCards(dados) {
        $('#totalVendas').text(formatarMoeda(dados.totalVendas));
        $('#qtdVendas').text(dados.quantidadeVendas);
        $('#ticketMedio').text(formatarMoeda(dados.ticketMedio));
        $('#provasConvertidas').text(dados.taxaConversao + '%');
    }

    // Função para atualizar os gráficos
    function atualizarGraficos(dados) {
        // Destrói os gráficos existentes
        Object.values(charts).forEach(chart => {
            if (chart) chart.destroy();
        });

        // Define altura fixa para os containers dos gráficos
        const alturaGrafico = 300;
        $('#vendasPorPeriodo').parent().height(alturaGrafico);
        $('#produtosMaisVendidos').parent().height(alturaGrafico);
        $('#vendasPorPagamento').parent().height(alturaGrafico);
        $('#melhoresClientes').parent().height(alturaGrafico);

        // Gráfico de vendas por período
        charts.vendasPorPeriodo = new Chart(document.getElementById('vendasPorPeriodo'), {
            type: 'line',
            data: {
                labels: dados.vendasPorPeriodo.labels,
                datasets: [{
                    label: 'Vendas',
                    data: dados.vendasPorPeriodo.valores,
                    borderColor: '#4e73df',
                    tension: 0.1,
                    fill: false
                }]
            },
            options: {
                responsive: true,
                maintainAspectRatio: false,
                plugins: {
                    legend: {
                        display: false
                    }
                }
            }
        });

        // Gráfico de produtos mais vendidos
        charts.produtosMaisVendidos = new Chart(document.getElementById('produtosMaisVendidos'), {
            type: 'doughnut',
            data: {
                labels: dados.produtosMaisVendidos.labels,
                datasets: [{
                    data: dados.produtosMaisVendidos.valores,
                    backgroundColor: [
                        '#4e73df', '#1cc88a', '#36b9cc',
                        '#f6c23e', '#e74a3b', '#858796'
                    ]
                }]
            },
            options: {
                responsive: true,
                maintainAspectRatio: false
            }
        });

        // Gráfico de vendas por forma de pagamento
        charts.vendasPorPagamento = new Chart(document.getElementById('vendasPorPagamento'), {
            type: 'bar',
            data: {
                labels: dados.vendasPorPagamento.labels,
                datasets: [{
                    label: 'Vendas',
                    data: dados.vendasPorPagamento.valores,
                    backgroundColor: '#4e73df'
                }]
            },
            options: {
                responsive: true,
                maintainAspectRatio: false,
                plugins: {
                    legend: {
                        display: false
                    }
                }
            }
        });

        // Gráfico de melhores clientes
        charts.melhoresClientes = new Chart(document.getElementById('melhoresClientes'), {
            type: 'bar',
            data: {
                labels: dados.melhoresClientes.labels,
                datasets: [{
                    label: 'Vendas',
                    data: dados.melhoresClientes.valores,
                    backgroundColor: '#1cc88a'
                }]
            },
            options: {
                responsive: true,
                maintainAspectRatio: false,
                indexAxis: 'y',
                plugins: {
                    legend: {
                        display: false
                    }
                }
            }
        });
    }

    // Função para formatar valores em moeda
    function formatarMoeda(valor) {
        return 'R$ ' + valor.toLocaleString('pt-BR', { minimumFractionDigits: 2, maximumFractionDigits: 2 });
    }
});
