// Função para verificar o status do caixa
function verificarCaixa() {
    return $.get('actions/check_caixa_status.php')
        .then(function(response) {
            if (!response.success) {
                throw new Error(response.message || 'Erro ao verificar status do caixa');
            }
            return response.caixaAberto;
        });
}

// Função para mostrar mensagem de caixa fechado
function mostrarMensagemCaixaFechado() {
    Swal.fire({
        title: 'Caixa Fechado',
        text: 'É necessário abrir o caixa antes de realizar vendas.',
        icon: 'warning',
        confirmButtonText: 'Ir para o Caixa',
        showCancelButton: true,
        cancelButtonText: 'Cancelar'
    }).then((result) => {
        if (result.isConfirmed) {
            window.location.href = 'caixa.php';
        }
    });
}

// Verifica o status do caixa ao carregar a página
$(document).ready(function() {
    // Só executa no PDV
    if (window.location.pathname.includes('pdv.php')) {
        verificarCaixa().then(function(caixaAberto) {
            if (!caixaAberto) {
                mostrarMensagemCaixaFechado();
                // Desabilita elementos do PDV
                $('#formVenda').find('input, select, button').prop('disabled', true);
            }
        }).catch(function(error) {
            console.error('Erro ao verificar caixa:', error);
            Swal.fire({
                title: 'Erro',
                text: 'Não foi possível verificar o status do caixa.',
                icon: 'error',
                confirmButtonText: 'OK'
            });
        });
    }
});
