$(document).ready(function() {
    // Smooth scroll para as categorias
    $('.nav-link').on('click', function(e) {
        if (this.hash !== '') {
            e.preventDefault();
            const hash = this.hash;
            
            $('html, body').animate({
                scrollTop: $(hash).offset().top - 100
            }, 800);
        }
    });

    // Adicionar ao carrinho
    $(document).on('click', '.btn-add-cart', function() {
        const productId = $(this).data('product-id');
        const button = $(this);
        
        // Adiciona classe de loading
        button.prop('disabled', true).html('<i class="bi bi-hourglass-split"></i>');
        
        // Simula adição ao carrinho (aqui você implementará a lógica real)
        setTimeout(() => {
            button.html('<i class="bi bi-check-lg"></i>');
            
            showToast('Produto adicionado ao carrinho!', 'success');
            
            // Retorna ao ícone original após 1 segundo
            setTimeout(() => {
                button.prop('disabled', false).html('<i class="bi bi-cart-plus"></i>');
            }, 1000);
        }, 500);
    });

    // Função para mostrar toast
    function showToast(message, type = 'success') {
        const bgColor = type === 'success' ? 'bg-success' : 'bg-danger';
        const toast = `
            <div class="toast ${bgColor} text-white" role="alert" aria-live="assertive" aria-atomic="true">
                <div class="d-flex">
                    <div class="toast-body">
                        ${message}
                    </div>
                    <button type="button" class="btn-close btn-close-white me-2 m-auto" data-bs-dismiss="toast" aria-label="Close"></button>
                </div>
            </div>
        `;
        
        $('.toast-container').append(toast);
        const toastElement = $('.toast').last();
        const bsToast = new bootstrap.Toast(toastElement);
        bsToast.show();
        
        // Remove o toast depois que ele é fechado
        toastElement.on('hidden.bs.toast', function () {
            $(this).remove();
        });
    }
});
