// Função para mostrar toast
function showToast(message, type = 'success') {
    const toastHtml = `
        <div class="toast align-items-center text-white bg-${type} border-0" role="alert" aria-live="assertive" aria-atomic="true">
            <div class="d-flex">
                <div class="toast-body">${message}</div>
                <button type="button" class="btn-close btn-close-white me-2 m-auto" data-bs-dismiss="toast" aria-label="Close"></button>
            </div>
        </div>
    `;
    
    const toastContainer = $('.toast-container');
    const toastElement = $(toastHtml);
    toastContainer.append(toastElement);
    
    const toast = new bootstrap.Toast(toastElement[0], {
        autohide: true,
        delay: 3000
    });
    
    toast.show();
    
    toastElement.on('hidden.bs.toast', function() {
        $(this).remove();
    });
}

// Função para inicializar o modal de exclusão
function initDeleteModal(options) {
    const {
        // Seletor do botão de excluir (ex: '.btn-excluir')
        deleteButtonSelector,
        // URL da ação de exclusão (ex: 'actions/delete_cliente.php')
        deleteUrl,
        // Função para recarregar os dados após exclusão
        reloadCallback,
        // Mensagem de sucesso personalizada (opcional)
        successMessage = 'Item excluído com sucesso!',
        // Mensagem de erro personalizada (opcional)
        errorMessage = 'Erro ao excluir item'
    } = options;

    // Manipula clique no botão excluir
    $(document).on('click', deleteButtonSelector, function() {
        const id = $(this).data('id');
        $('#excluir_cliente_id').val(id);
        $('#modalConfirmarExclusao').modal('show');
    });

    // Manipula confirmação de exclusão
    $(document).on('click', '#btnConfirmarExclusao', function() {
        const id = $('#excluir_cliente_id').val();
        
        $.post(deleteUrl, { id: id })
            .done(function(response) {
                $('#modalConfirmarExclusao').modal('hide');
                if (response.success) {
                    // Executa o callback de recarga
                    if (typeof reloadCallback === 'function') {
                        reloadCallback();
                    }
                    showToast(response.message || successMessage);
                } else {
                    showToast(response.message || errorMessage, 'danger');
                }
            })
            .fail(function() {
                $('#modalConfirmarExclusao').modal('hide');
                showToast(errorMessage, 'danger');
            });
    });
}
