$(document).ready(function() {
    // Função para carregar os dados dos cards
    function carregarDadosDashboard() {
        console.log('Carregando dados do dashboard...');
        
        $.get('actions/get_dashboard_data.php')
            .done(function(response) {
                console.log('Resposta recebida:', response);
                
                // Atualiza total de clientes
                $('#totalClientes').text(response.clientes || '0');
                console.log('Total de clientes:', response.clientes);
                
                // Atualiza total de produtos
                $('#totalProdutos').text(response.produtos || '0');
                
                // Atualiza total de provas
                $('#totalProvas').text(response.provas || '0');
                
                // Atualiza total de vendas
                if (response.vendas) {
                    $('#totalVendas').text(formatarMoeda(response.vendas));
                }
            })
            .fail(function(jqXHR, textStatus, errorThrown) {
                console.error('Erro ao carregar dados:', textStatus, errorThrown);
            });
    }

    // Função para formatar valores em moeda
    function formatarMoeda(valor) {
        return new Intl.NumberFormat('pt-BR', {
            style: 'currency',
            currency: 'BRL'
        }).format(valor);
    }

    // Carrega os dados inicialmente
    carregarDadosDashboard();
    
    // Atualiza os dados a cada 30 segundos
    setInterval(carregarDadosDashboard, 30000);
});
