<?php
require_once '../includes/config.php';

try {
    $pdo = getConnection();
    
    // Buscar configurações da empresa
    $query = "SELECT * FROM config_empresa WHERE id = 1";
    $stmt = $pdo->prepare($query);
    $stmt->execute();
    $config_empresa = $stmt->fetch();
    
    // Buscar configurações do site
    $query = "SELECT * FROM config_site WHERE id = 1";
    $stmt = $pdo->prepare($query);
    $stmt->execute();
    $config_site = $stmt->fetch();
    
    // Buscar configurações de cores
    $query = "SELECT * FROM config_estilo_cores WHERE id = 1";
    $stmt = $pdo->prepare($query);
    $stmt->execute();
    $cores = $stmt->fetch();
    
    // Buscar redes sociais
    $query = "SELECT * FROM config_redes_sociais WHERE ativo = 1";
    $stmt = $pdo->prepare($query);
    $stmt->execute();
    $redes_sociais = $stmt->fetchAll();
    
    // Contar produtos ativos
    $query = "SELECT COUNT(*) as total FROM produtos WHERE ativo = 1";
    $stmt = $pdo->prepare($query);
    $stmt->execute();
    $produtos = $stmt->fetch();
    
    // Contar clientes
    $query = "SELECT COUNT(*) as total FROM clientes";
    $stmt = $pdo->prepare($query);
    $stmt->execute();
    $clientes = $stmt->fetch();
    
    echo json_encode(array(
        "success" => true,
        "config_empresa" => $config_empresa,
        "config_site" => $config_site,
        "cores" => $cores,
        "redes_sociais" => $redes_sociais,
        "produtos_ativos" => $produtos['total'],
        "total_clientes" => $clientes['total']
    ));
    
} catch (PDOException $e) {
    http_response_code(500);
    echo json_encode(array("error" => "Erro ao carregar status do site: " . $e->getMessage()));
}
