<?php
require_once '../includes/config.php';

try {
    $pdo = getConnection();
    
    $query = "SELECT p.*, c.nome as categoria_nome 
              FROM produtos p 
              LEFT JOIN categorias c ON p.categoria_id = c.id 
              ORDER BY p.nome";
    
    $stmt = $pdo->prepare($query);
    $stmt->execute();
    $produtos = $stmt->fetchAll();
    
    // Formatar dados para o DataTables
    $data = array();
    foreach ($produtos as $produto) {
        $row = array();
        $row[] = $produto['id'];
        $row[] = $produto['nome'];
        $row[] = $produto['categoria_nome'] ?? 'Sem categoria';
        $row[] = 'R$ ' . number_format($produto['preco'], 2, ',', '.');
        $row[] = $produto['ativo'] ? 'Ativo' : 'Inativo';
        $row[] = '<button class="btn btn-sm btn-primary editar-produto" data-id="'.$produto['id'].'">Editar</button> 
                  <button class="btn btn-sm btn-danger excluir-produto" data-id="'.$produto['id'].'">Excluir</button>';
        $data[] = $row;
    }
    
    echo json_encode(array(
        "draw" => isset($_POST['draw']) ? intval($_POST['draw']) : 0,
        "recordsTotal" => count($produtos),
        "recordsFiltered" => count($produtos),
        "data" => $data
    ));
    
} catch (PDOException $e) {
    http_response_code(500);
    echo json_encode(array("error" => "Erro ao carregar produtos: " . $e->getMessage()));
}
