<?php
// Verifica se o usuário está logado
if (!isset($_SESSION['user_id'])) {
    header('Location: login.php');
    exit;
}

// Pega o nome da página atual
$current_page = basename($_SERVER['PHP_SELF']);
?>

<!-- Botão do Menu Mobile -->
<button class="menu-toggle d-lg-none">
    <i class="bi bi-list"></i> Menu
</button>

<!-- Overlay para fechar o menu -->
<div class="sidebar-overlay"></div>

<!-- Sidebar -->
<div class="sidebar">
    <div class="logo-container">
        <?php if (!empty($config_empresa['logo'])): ?>
            <img src="<?php echo htmlspecialchars('../' . $config_empresa['logo']); ?>" alt="Logo" class="img-fluid">
        <?php else: ?>
            <h4 class="text-white mb-0">Painel Admin</h4>
        <?php endif; ?>
    </div>
    
    <ul class="nav flex-column">
        <li class="nav-item">
            <a class="nav-link <?php echo $current_page == 'index.php' ? 'active' : ''; ?>" href="index.php">
                <i class="bi bi-house-door"></i> Dashboard
            </a>
        </li>
        <li class="nav-item">
            <a class="nav-link <?php echo $current_page == 'clientes.php' ? 'active' : ''; ?>" href="clientes.php">
                <i class="bi bi-people"></i> Clientes
            </a>
        </li>
        <li class="nav-item">
            <a class="nav-link <?php echo $current_page == 'produtos.php' ? 'active' : ''; ?>" href="produtos.php">
                <i class="bi bi-box"></i> Produtos
            </a>
        </li>
        <li class="nav-item">
            <a class="nav-link <?php echo $current_page == 'pdv.php' ? 'active' : ''; ?>" href="pdv.php">
                <i class="bi bi-cart"></i> PDV
            </a>
        </li>
        <li class="nav-item">
            <a class="nav-link <?php echo $current_page == 'caixa.php' ? 'active' : ''; ?>" href="caixa.php">
                <i class="bi bi-cash-stack"></i> Caixa
            </a>
        </li>
        <li class="nav-item">
            <a class="nav-link <?php echo $current_page == 'vendas.php' ? 'active' : ''; ?>" href="vendas.php">
                <i class="bi bi-graph-up"></i> Vendas
            </a>
        </li>
        <li class="nav-item">
            <a class="nav-link <?php echo $current_page == 'provas.php' ? 'active' : ''; ?>" href="provas.php">
                <i class="bi bi-file-text"></i> Provas
            </a>
        </li>
        <li class="nav-item">
            <a class="nav-link <?php echo $current_page == 'relatorios.php' ? 'active' : ''; ?>" href="relatorios.php">
                <i class="bi bi-file-earmark-text"></i> Relatórios
            </a>
        </li>
        <li class="nav-item">
            <a class="nav-link <?php echo $current_page == 'marketing.php' ? 'active' : ''; ?>" href="marketing.php">
                <i class="bi bi-megaphone"></i> Marketing
            </a>
        </li>
        <li class="nav-item">
            <a class="nav-link <?php echo $current_page == 'usuarios.php' ? 'active' : ''; ?>" href="usuarios.php">
                <i class="bi bi-people"></i> Usuários
            </a>
        </li>
        <li class="nav-item">
            <a class="nav-link <?php echo $current_page == 'configuracoes.php' ? 'active' : ''; ?>" href="configuracoes.php">
                <i class="bi bi-gear"></i> Configurações
            </a>
        </li>
        <li class="nav-item mt-4">
            <a class="nav-link" href="logout.php">
                <i class="bi bi-box-arrow-right"></i> Sair
            </a>
        </li>
    </ul>
</div>

<!-- Toast Container para notificações -->
<div class="toast-container"></div>

<!-- JavaScript para controlar o menu mobile -->
<script>
document.addEventListener('DOMContentLoaded', function() {
    const menuToggle = document.querySelector('.menu-toggle');
    const sidebar = document.querySelector('.sidebar');
    const overlay = document.querySelector('.sidebar-overlay');

    function toggleMenu() {
        sidebar.classList.toggle('show');
        overlay.classList.toggle('show');
    }

    menuToggle.addEventListener('click', toggleMenu);
    overlay.addEventListener('click', toggleMenu);
});
</script>