<?php
require_once '../includes/config.php';
require_once '../includes/functions.php';

// Verifica se o usuário está logado
session_start();
if (!isset($_SESSION['user_id'])) {
    header('Location: login.php');
    exit;
}

// Busca as configurações atuais
try {
    $pdo = getConnection();
    $stmt = $pdo->query("SELECT * FROM config_site LIMIT 1");
    $config = $stmt->fetch(PDO::FETCH_ASSOC);
} catch (Exception $e) {
    error_log("Erro ao buscar configurações: " . $e->getMessage());
    $config = [];
}
?>
<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo formatPageTitle('Configurações'); ?></title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css" rel="stylesheet">
    <link href="css/admin.css" rel="stylesheet">
</head>
<body>
    <?php include 'header.php'; ?>

    <main class="main-content">
        <div class="container-fluid">
            <div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pb-2 mb-3 border-bottom">
                <h2 class="h4 mb-0">
                    <i class="bi bi-gear me-2"></i>Configurações do Site
                </h2>
            </div>

            <form id="configForm" class="needs-validation" enctype="multipart/form-data" novalidate>
                <!-- Configurações Gerais -->
                <div class="card mb-4">
                    <div class="card-header bg-light">
                        <h5 class="card-title mb-0">
                            <i class="bi bi-sliders me-2"></i>
                            Configurações Gerais
                        </h5>
                    </div>
                    <div class="card-body">
                        <div class="row g-3">
                            <!-- Status do Site -->
                            <div class="col-12">
                                <div class="form-check form-switch">
                                    <input class="form-check-input" type="checkbox" id="site_ativo" name="site_ativo" 
                                           <?php echo (!isset($config['site_ativo']) || $config['site_ativo']) ? 'checked' : ''; ?>>
                                    <label class="form-check-label" for="site_ativo">Site Ativo</label>
                                </div>
                            </div>

                            <!-- Nome da Empresa -->
                            <div class="col-md-6">
                                <label for="nome_empresa" class="form-label">Nome da Empresa</label>
                                <input type="text" class="form-control" id="nome_empresa" name="nome_empresa" 
                                       value="<?php echo htmlspecialchars($config['nome_empresa'] ?? ''); ?>" required>
                            </div>

                            <!-- Slide Ativo -->
                            <div class="col-12">
                                <div class="form-check form-switch">
                                    <input class="form-check-input" type="checkbox" id="slide_ativo" name="slide_ativo" 
                                           <?php echo (!isset($config['slide_ativo']) || $config['slide_ativo']) ? 'checked' : ''; ?>>
                                    <label class="form-check-label" for="slide_ativo">Slide Ativo</label>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Configurações do Slide -->
                <div class="card mb-4">
                    <div class="card-header bg-light">
                        <h5 class="card-title mb-0">
                            <i class="bi bi-images me-2"></i>
                            Configurações do Slide
                        </h5>
                    </div>
                    <div class="card-body">
                        <div class="row g-3">
                            <!-- Imagem do Slide -->
                            <div class="col-12">
                                <label for="slide_image" class="form-label">Imagem do Slide</label>
                                <input type="file" class="form-control" id="slide_image" name="slide_image" accept="image/*">
                                <?php if (!empty($config['slide_image'])): ?>
                                    <div class="mt-2">
                                        <img src="<?php echo '../uploads/slides/' . htmlspecialchars($config['slide_image']); ?>" 
                                             class="img-thumbnail" alt="Slide atual" style="max-height: 200px;">
                                    </div>
                                <?php endif; ?>
                            </div>

                            <!-- Texto Principal -->
                            <div class="col-md-6">
                                <label for="slide_texto_principal" class="form-label">Texto Principal</label>
                                <input type="text" class="form-control" id="slide_texto_principal" name="slide_texto_principal" 
                                       value="<?php echo htmlspecialchars($config['slide_texto_principal'] ?? ''); ?>">
                            </div>

                            <!-- Texto Secundário -->
                            <div class="col-md-6">
                                <label for="slide_texto_secundario" class="form-label">Texto Secundário</label>
                                <input type="text" class="form-control" id="slide_texto_secundario" name="slide_texto_secundario" 
                                       value="<?php echo htmlspecialchars($config['slide_texto_secundario'] ?? ''); ?>">
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Botões de Ação -->
                <div class="d-flex justify-content-end gap-2 mb-4">
                    <button type="submit" class="btn btn-primary">
                        <i class="bi bi-save me-2"></i>
                        Salvar Alterações
                    </button>
                </div>
            </form>
        </div>
    </main>

    <!-- Bootstrap Bundle JS -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    
    <!-- Custom JavaScript -->
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            const form = document.getElementById('configForm');
            
            form.addEventListener('submit', async function(e) {
                e.preventDefault();
                
                const formData = new FormData(this);
                
                try {
                    const response = await fetch('../actions/save_site_config.php', {
                        method: 'POST',
                        body: formData
                    });
                    
                    const data = await response.json();
                    
                    if (data.success) {
                        alert('Configurações salvas com sucesso!');
                        location.reload();
                    } else {
                        alert('Erro ao salvar configurações: ' + data.message);
                    }
                } catch (error) {
                    console.error('Erro:', error);
                    alert('Erro ao salvar configurações. Por favor, tente novamente.');
                }
            });
            
            // Preview da imagem
            document.getElementById('slide_image').addEventListener('change', function(e) {
                if (this.files && this.files[0]) {
                    const reader = new FileReader();
                    reader.onload = function(e) {
                        const preview = document.querySelector('.img-thumbnail');
                        if (preview) {
                            preview.src = e.target.result;
                        } else {
                            const newPreview = document.createElement('img');
                            newPreview.src = e.target.result;
                            newPreview.classList.add('img-thumbnail', 'mt-2');
                            newPreview.style.maxHeight = '200px';
                            this.parentElement.appendChild(newPreview);
                        }
                    }.bind(this);
                    reader.readAsDataURL(this.files[0]);
                }
            });
        });
    </script>
</body>
</html>
