<?php
session_start();
require_once '../includes/conexao.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $caixa_id = filter_input(INPUT_POST, 'caixa_id', FILTER_VALIDATE_INT);
    $valor_fechamento = filter_input(INPUT_POST, 'valor_fechamento', FILTER_VALIDATE_FLOAT);
    $observacao = filter_input(INPUT_POST, 'observacao', FILTER_SANITIZE_STRING);

    try {
        // Verifica se o caixa existe e está aberto
        $stmt = $pdo->prepare("SELECT id FROM caixa WHERE id = :id AND status = 'aberto'");
        $stmt->execute([':id' => $caixa_id]);
        if (!$stmt->fetch()) {
            $_SESSION['erro'] = "Caixa não encontrado ou já está fechado!";
            header('Location: ../caixa.php');
            exit;
        }

        // Fecha o caixa
        $stmt = $pdo->prepare("
            UPDATE caixa 
            SET status = 'fechado',
                valor_fechamento = :valor_fechamento,
                data_fechamento = NOW(),
                observacao = CASE 
                    WHEN observacao IS NULL OR observacao = '' THEN :observacao
                    ELSE CONCAT(observacao, ' | Fechamento: ', :observacao)
                END
            WHERE id = :id
        ");

        $stmt->execute([
            ':valor_fechamento' => $valor_fechamento,
            ':observacao' => $observacao,
            ':id' => $caixa_id
        ]);

        $_SESSION['sucesso'] = "Caixa fechado com sucesso!";
    } catch (PDOException $e) {
        $_SESSION['erro'] = "Erro ao fechar o caixa: " . $e->getMessage();
    }
}

header('Location: ../caixa.php');
