<?php
session_start();
require_once '../includes/conexao.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $valor_abertura = filter_input(INPUT_POST, 'valor_abertura', FILTER_VALIDATE_FLOAT);
    $observacao = filter_input(INPUT_POST, 'observacao', FILTER_SANITIZE_STRING);
    $usuario_id = $_SESSION['user_id'];

    try {
        // Verifica se já existe um caixa aberto
        $stmt = $pdo->prepare("SELECT id FROM caixa WHERE status = 'aberto'");
        $stmt->execute();
        if ($stmt->fetch()) {
            $_SESSION['erro'] = "Já existe um caixa aberto!";
            header('Location: ../caixa.php');
            exit;
        }

        // Insere novo registro de caixa
        $stmt = $pdo->prepare("
            INSERT INTO caixa (status, valor_abertura, data_abertura, usuario_id, observacao)
            VALUES ('aberto', :valor_abertura, NOW(), :usuario_id, :observacao)
        ");

        $stmt->execute([
            ':valor_abertura' => $valor_abertura,
            ':usuario_id' => $usuario_id,
            ':observacao' => $observacao
        ]);

        $_SESSION['sucesso'] = "Caixa aberto com sucesso!";
    } catch (PDOException $e) {
        $_SESSION['erro'] = "Erro ao abrir o caixa: " . $e->getMessage();
    }
}

header('Location: ../caixa.php');
