<?php
require_once '../config/database.php';

try {
    $database = new Database();
    $db = $database->getConnection();

    // Buscar cores da tabela config_estilo_cores
    $query = "SELECT * FROM config_estilo_cores WHERE id = 1";
    $stmt = $db->prepare($query);
    
    if ($stmt->execute()) {
        $cores = $stmt->fetch(PDO::FETCH_ASSOC);
        
        if ($cores) {
            // Converter cores hex para RGB
            function hexToRgb($hex) {
                $hex = str_replace('#', '', $hex);
                if(strlen($hex) == 3) {
                    $r = hexdec(substr($hex,0,1).substr($hex,0,1));
                    $g = hexdec(substr($hex,1,1).substr($hex,1,1));
                    $b = hexdec(substr($hex,2,1).substr($hex,2,1));
                } else {
                    $r = hexdec(substr($hex,0,2));
                    $g = hexdec(substr($hex,2,2));
                    $b = hexdec(substr($hex,4,2));
                }
                return "$r, $g, $b";
            }

            // Gerar conteúdo do arquivo theme.css
            $css = ":root {
    --cor-principal: {$cores['cor_principal']};
    --cor-secundaria: {$cores['cor_secundaria']};
    --cor-terciaria: {$cores['cor_terciaria']};
    --cor-texto: {$cores['cor_texto']};
    --cor-clara: #fff;
    --cor-principal-rgb: " . hexToRgb($cores['cor_principal']) . ";
    --cor-secundaria-rgb: " . hexToRgb($cores['cor_secundaria']) . ";
    --cor-terciaria-rgb: " . hexToRgb($cores['cor_terciaria']) . ";
    --cor-texto-rgb: " . hexToRgb($cores['cor_texto']) . ";
}

/* Estilos do Sidebar */
#sidebar {
    background: var(--cor-principal);
    color: var(--cor-clara);
}

#sidebar .sidebar-header {
    background: var(--cor-secundaria);
}

#sidebar ul li a {
    color: var(--cor-clara);
}

#sidebar ul li a:hover {
    background: var(--cor-secundaria);
}

#sidebar ul li.active > a {
    background: var(--cor-secundaria);
}

/* Estilos do Conteúdo Principal */
.navbar {
    background: var(--cor-principal);
}

.navbar-title {
    color: var(--cor-clara);
}

/* Estilos dos Botões */
.btn-primary {
    background-color: var(--cor-principal);
    border-color: var(--cor-principal);
    color: var(--cor-clara);
}

.btn-primary:hover {
    background-color: var(--cor-secundaria);
    border-color: var(--cor-secundaria);
}

.btn-outline-primary {
    color: var(--cor-principal);
    border-color: var(--cor-principal);
}

.btn-outline-primary:hover {
    background-color: var(--cor-principal);
    border-color: var(--cor-principal);
    color: var(--cor-clara);
}

/* Estilos dos inputs */
.form-control:focus {
    border-color: var(--cor-principal);
    box-shadow: 0 0 0 0.25rem rgba(var(--cor-principal-rgb), 0.25);
}

/* Estilos dos cards */
.card-header {
    background-color: var(--cor-principal);
    color: var(--cor-clara);
}

.card {
    border-color: var(--cor-principal);
}

/* Estilos das Tabs */
.nav-tabs .nav-link {
    color: var(--cor-texto);
}

.nav-tabs .nav-link:hover {
    color: var(--cor-principal);
}

.nav-tabs .nav-link.active {
    color: var(--cor-principal);
    border-color: var(--cor-principal);
}

/* Estilos de Links */
a {
    color: var(--cor-principal);
}

a:hover {
    color: var(--cor-secundaria);
}

/* Estilos de Texto */
body {
    color: var(--cor-texto);
}

h1, h2, h3, h4, h5, h6 {
    color: var(--cor-terciaria);
}

/* Estilos de Tabelas */
.table {
    color: var(--cor-texto);
}

.table-striped tbody tr:nth-of-type(odd) {
    background-color: rgba(var(--cor-principal-rgb), 0.05);
}

.table thead th {
    background-color: var(--cor-principal);
    color: var(--cor-clara);
}

/* Estilos de Alertas e Mensagens */
.alert-primary {
    background-color: rgba(var(--cor-principal-rgb), 0.1);
    border-color: var(--cor-principal);
    color: var(--cor-principal);
}

/* Estilos de Badges */
.badge-primary {
    background-color: var(--cor-principal);
    color: var(--cor-clara);
}

/* Estilos de Progress Bars */
.progress-bar {
    background-color: var(--cor-principal);
}

/* Estilos de Dropdown */
.dropdown-item:hover {
    background-color: var(--cor-principal);
    color: var(--cor-clara);
}

/* Estilos de Paginação */
.page-link {
    color: var(--cor-principal);
}

.page-item.active .page-link {
    background-color: var(--cor-principal);
    border-color: var(--cor-principal);
}

/* Estilos de Toast */
.toast-header {
    background-color: var(--cor-principal);
    color: var(--cor-clara);
}";

            // Salvar o arquivo theme.css
            $theme_file = '../assets/css/theme.css';
            if (file_put_contents($theme_file, $css)) {
                echo json_encode(['success' => true, 'message' => 'Tema atualizado com sucesso']);
            } else {
                throw new Exception('Erro ao salvar o arquivo theme.css');
            }
        } else {
            throw new Exception('Nenhuma configuração de cores encontrada');
        }
    } else {
        throw new Exception('Erro ao buscar configurações de cores');
    }
} catch (Exception $e) {
    error_log("Erro ao atualizar tema: " . $e->getMessage());
    echo json_encode(['success' => false, 'message' => $e->getMessage()]);
}
?>
