<?php
require_once '../includes/config.php';
require_once '../includes/functions.php';

header('Content-Type: application/json');

try {
    if (empty($_POST['id']) || empty($_POST['nome'])) {
        throw new Exception('ID e nome da categoria são obrigatórios');
    }

    $pdo = getConnection();
    
    $stmt = $pdo->prepare("UPDATE categorias SET nome = ? WHERE id = ?");
    $stmt->execute([$_POST['nome'], $_POST['id']]);
    
    echo json_encode([
        'success' => true,
        'message' => 'Categoria atualizada com sucesso'
    ]);

} catch (Exception $e) {
    error_log("Erro ao atualizar categoria: " . $e->getMessage());
    echo json_encode([
        'success' => false,
        'message' => $e->getMessage()
    ]);
}
