<?php
require_once '../includes/config.php';

header('Content-Type: application/json');

try {
    $pdo = getConnection();
    
    // Verifica se a tabela existe
    $stmt = $pdo->query("SHOW TABLES LIKE 'config_site'");
    if ($stmt->rowCount() == 0) {
        // Cria a tabela se não existir
        $pdo->exec("CREATE TABLE IF NOT EXISTS config_site (
            id INT AUTO_INCREMENT PRIMARY KEY,
            site_ativo BOOLEAN DEFAULT TRUE,
            slide_ativo BOOLEAN DEFAULT TRUE,
            ultima_atualizacao TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
            slide_texto_principal TEXT,
            slide_texto_secundario TEXT,
            slide_image TEXT,
            nome_empresa VARCHAR(255),
            created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
        )");
    }
    
    // Verifica se a coluna nome_empresa existe
    $stmt = $pdo->query("SHOW COLUMNS FROM config_site LIKE 'nome_empresa'");
    if ($stmt->rowCount() == 0) {
        // Adiciona a coluna se não existir
        $pdo->exec("ALTER TABLE config_site ADD COLUMN nome_empresa VARCHAR(255)");
    }
    
    // Recebe e sanitiza os dados
    $site_ativo = isset($_POST['site_ativo']) ? (int)$_POST['site_ativo'] : 1;
    $slide_ativo = isset($_POST['slide_ativo']) ? (int)$_POST['slide_ativo'] : 1;
    $slide_texto_principal = trim($_POST['slide_texto_principal'] ?? 'Bem-vinda à Loja');
    $slide_texto_secundario = trim($_POST['slide_texto_secundario'] ?? 'Encontre as melhores peças aqui');
    $nome_empresa = trim($_POST['nome_empresa'] ?? '');
    
    // Verifica se já existe configuração
    $stmt = $pdo->query("SELECT id FROM config_site LIMIT 1");
    $config = $stmt->fetch(PDO::FETCH_ASSOC);
    
    if ($config) {
        // Atualiza configuração existente
        $query = "UPDATE config_site SET 
                    site_ativo = ?,
                    slide_ativo = ?,
                    slide_texto_principal = ?,
                    slide_texto_secundario = ?,
                    nome_empresa = ?,
                    ultima_atualizacao = NOW()
                 WHERE id = ?";
        $stmt = $pdo->prepare($query);
        $stmt->execute([
            $site_ativo,
            $slide_ativo,
            $slide_texto_principal,
            $slide_texto_secundario,
            $nome_empresa,
            $config['id']
        ]);
        $config_id = $config['id'];
    } else {
        // Insere nova configuração
        $query = "INSERT INTO config_site 
                    (site_ativo, slide_ativo, slide_texto_principal, slide_texto_secundario, nome_empresa, ultima_atualizacao) 
                 VALUES (?, ?, ?, ?, ?, NOW())";
        $stmt = $pdo->prepare($query);
        $stmt->execute([
            $site_ativo,
            $slide_ativo,
            $slide_texto_principal,
            $slide_texto_secundario,
            $nome_empresa
        ]);
        $config_id = $pdo->lastInsertId();
    }
    
    // Processa a imagem do slide se foi enviada
    if (isset($_FILES['slide_image']) && $_FILES['slide_image']['error'] === UPLOAD_ERR_OK) {
        error_log("Processando upload da imagem do slide");
        
        $uploadDir = __DIR__ . '/../uploads/slides/';
        if (!file_exists($uploadDir)) {
            error_log("Criando diretório: " . $uploadDir);
            if (!mkdir($uploadDir, 0777, true)) {
                throw new Exception("Não foi possível criar o diretório de upload");
            }
        }
        
        // Gera um nome único para o arquivo
        $fileInfo = pathinfo($_FILES['slide_image']['name']);
        $fileName = 'slide_' . uniqid() . '_' . time() . '.' . $fileInfo['extension'];
        $uploadFile = $uploadDir . $fileName;
        
        error_log("Tentando mover arquivo para: " . $uploadFile);
        
        if (move_uploaded_file($_FILES['slide_image']['tmp_name'], $uploadFile)) {
            error_log("Arquivo movido com sucesso");
            
            // Atualiza o nome da imagem no banco com o caminho relativo
            $relativePath = 'uploads/slides/' . $fileName;
            $stmt = $pdo->prepare("UPDATE config_site SET slide_image = ? WHERE id = ?");
            $stmt->execute([$relativePath, $config_id]);
            
            error_log("Nome da imagem atualizado no banco: " . $relativePath);
        } else {
            error_log("Erro ao mover arquivo. Upload error code: " . $_FILES['slide_image']['error']);
            throw new Exception("Erro ao fazer upload da imagem");
        }
    } else if (isset($_FILES['slide_image'])) {
        error_log("Erro no upload da imagem. Código: " . $_FILES['slide_image']['error']);
    }
    
    echo json_encode([
        'success' => true,
        'message' => 'Configurações salvas com sucesso'
    ]);
    
} catch (Exception $e) {
    error_log("Erro ao salvar configurações do site: " . $e->getMessage());
    if (isset($e->errorInfo)) {
        error_log("SQL State: " . $e->errorInfo[0] . "\nError Code: " . $e->errorInfo[1]);
    }
    echo json_encode([
        'success' => false,
        'message' => 'Erro ao salvar configurações do site: ' . $e->getMessage()
    ]);
}
