<?php
header('Content-Type: application/json');
require_once '../config/database.php';

try {
    $database = new Database();
    $db = $database->getConnection();

    if (!$db) {
        throw new Exception("Erro ao conectar ao banco de dados");
    }

    // Log dos dados recebidos
    error_log("Dados recebidos: " . print_r($_POST, true));

    // Validar dados obrigatórios
    if (empty($_POST['nome'])) {
        throw new Exception("Nome é obrigatório");
    }

    // Preparar dados
    $id = $_POST['id'] ?? null;
    $data = [
        'nome' => $_POST['nome'],
        'endereco' => $_POST['endereco'] ?? null,
        'numero' => $_POST['numero'] ?? null,
        'bairro' => $_POST['bairro'] ?? null,
        'cidade' => $_POST['cidade'] ?? null,
        'telefone' => $_POST['telefone'] ?? null,
        'instagram' => $_POST['instagram'] ?? null
    ];

    // Log dos dados preparados
    error_log("Dados preparados: " . print_r($data, true));

    // Remover @ do início do Instagram se existir
    if ($data['instagram']) {
        $data['instagram'] = ltrim($data['instagram'], '@');
    }

    if ($id) {
        // Atualizar cliente existente
        $query = "UPDATE clientes SET 
                  nome = :nome,
                  endereco = :endereco,
                  numero = :numero,
                  bairro = :bairro,
                  cidade = :cidade,
                  telefone = :telefone,
                  instagram = :instagram,
                  updated_at = NOW()
                  WHERE id = :id";
        
        $stmt = $db->prepare($query);
        $stmt->bindParam(':id', $id);
        error_log("Query de atualização: " . $query);
    } else {
        // Inserir novo cliente
        $query = "INSERT INTO clientes (
                    nome, endereco, numero, bairro, cidade, telefone, instagram, created_at, updated_at
                  ) VALUES (
                    :nome, :endereco, :numero, :bairro, :cidade, :telefone, :instagram, NOW(), NOW()
                  )";
        
        $stmt = $db->prepare($query);
        error_log("Query de inserção: " . $query);
    }

    // Bind parameters
    foreach ($data as $key => $value) {
        $stmt->bindValue(":$key", $value);
        error_log("Binding $key = " . ($value ?? 'NULL'));
    }

    if ($stmt->execute()) {
        $response = [
            'success' => true,
            'message' => $id ? 'Cliente atualizado com sucesso!' : 'Cliente cadastrado com sucesso!'
        ];
        error_log("Sucesso: " . print_r($response, true));
        echo json_encode($response);
    } else {
        $error = $stmt->errorInfo();
        throw new Exception("Erro ao salvar cliente: " . print_r($error, true));
    }
} catch (Exception $e) {
    $error = [
        'success' => false,
        'message' => $e->getMessage()
    ];
    error_log("Erro: " . print_r($error, true));
    echo json_encode($error);
}
?>
