<?php
require_once '../includes/config.php';
require_once '../includes/functions.php';

header('Content-Type: application/json');

try {
    if (empty($_POST['nome'])) {
        throw new Exception('Nome da categoria é obrigatório');
    }

    $pdo = getConnection();
    
    $stmt = $pdo->prepare("INSERT INTO categorias (nome) VALUES (?)");
    $stmt->execute([$_POST['nome']]);
    
    echo json_encode([
        'success' => true,
        'message' => 'Categoria cadastrada com sucesso'
    ]);

} catch (Exception $e) {
    error_log("Erro ao salvar categoria: " . $e->getMessage());
    echo json_encode([
        'success' => false,
        'message' => $e->getMessage()
    ]);
}
