<?php
header('Content-Type: application/json');
require_once '../config/database.php';

try {
    $database = new Database();
    $db = $database->getConnection();

    $hash = $_POST['hash'] ?? '';
    
    // Buscar configuração pelo hash
    $query = "SELECT * FROM config_history WHERE revert_hash = :hash";
    $stmt = $db->prepare($query);
    $stmt->bindParam(':hash', $hash);
    $stmt->execute();

    $config = $stmt->fetch(PDO::FETCH_ASSOC);
    
    if (!$config) {
        throw new Exception('Configuração não encontrada');
    }

    $data = json_decode($config['config_data'], true);
    
    // Reverter configuração baseado no tipo
    switch($config['config_type']) {
        case 'empresa':
            $query = "UPDATE config_empresa SET 
                      nome_empresa = :nome_empresa,
                      cnpj = :cnpj,
                      endereco = :endereco,
                      numero = :numero,
                      bairro = :bairro,
                      cep = :cep,
                      cidade = :cidade,
                      celular = :celular,
                      email = :email
                      WHERE id = 1";

            $stmt = $db->prepare($query);
            foreach($data as $key => $value) {
                $stmt->bindValue(':' . $key, $value);
            }
            break;

        case 'redes_sociais':
            $query = "UPDATE config_redes_sociais SET 
                      facebook = :facebook,
                      instagram = :instagram,
                      tiktok = :tiktok,
                      linkedin = :linkedin
                      WHERE id = 1";

            $stmt = $db->prepare($query);
            foreach($data as $key => $value) {
                $stmt->bindValue(':' . $key, $value);
            }
            break;

        case 'estilo':
            $query = "UPDATE config_estilo_cores SET 
                      cor_primaria = :cor_primaria,
                      cor_secundaria = :cor_secundaria,
                      cor_terciaria = :cor_terciaria,
                      cor_texto = :cor_texto
                      WHERE id = 1";

            $stmt = $db->prepare($query);
            foreach($data as $key => $value) {
                $stmt->bindValue(':' . $key, $value);
            }
            break;

        default:
            throw new Exception('Tipo de configuração não suportado para reversão');
    }

    if ($stmt->execute()) {
        // Se for uma configuração de estilo, atualizar o CSS
        if ($config['config_type'] === 'estilo') {
            $update_url = 'http://' . $_SERVER['HTTP_HOST'] . dirname($_SERVER['PHP_SELF']) . '/update_theme.php';
            $ch = curl_init($update_url);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            curl_exec($ch);
            curl_close($ch);
        }

        echo json_encode(['success' => true, 'message' => 'Configuração revertida com sucesso']);
    } else {
        throw new Exception('Erro ao reverter configuração');
    }

} catch(Exception $e) {
    echo json_encode(['success' => false, 'message' => $e->getMessage()]);
}
?>
