<?php
require_once '../config/database.php';
require_once '../includes/auth.php';
header('Content-Type: application/json');

try {
    $database = new Database();
    $conn = $database->getConnection();
    
    $stmt = $conn->prepare("SELECT id, nome, permissoes FROM usuarios ORDER BY nome");
    $stmt->execute();
    
    $usuarios = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    // Log para debug
    error_log('Usuários encontrados: ' . print_r($usuarios, true));
    
    echo json_encode([
        'success' => true,
        'usuarios' => $usuarios
    ]);
} catch (Exception $e) {
    error_log('Erro ao listar usuários: ' . $e->getMessage());
    echo json_encode([
        'success' => false,
        'message' => 'Erro ao listar usuários: ' . $e->getMessage()
    ]);
}
?>
