<?php
require_once '../includes/config.php';

try {
    if (!isset($_FILES['sql_file']) || $_FILES['sql_file']['error'] !== UPLOAD_ERR_OK) {
        throw new Exception('Erro no upload do arquivo.');
    }

    $sqlFile = $_FILES['sql_file']['tmp_name'];
    $sqlContent = file_get_contents($sqlFile);
    
    if (empty($sqlContent)) {
        throw new Exception('Arquivo SQL vazio.');
    }

    // Verifica se o conteúdo parece ser SQL válido
    if (strpos($sqlContent, 'SET FOREIGN_KEY_CHECKS=0') === false) {
        throw new Exception('Arquivo SQL inválido. Por favor, use um arquivo de backup gerado pelo sistema.');
    }

    $db = getConnection();
    
    // Desativa verificações de chave estrangeira
    $db->exec('SET FOREIGN_KEY_CHECKS = 0');
    
    try {
        // Remove comentários SQL
        $sqlContent = preg_replace('/--.*\n/', '', $sqlContent);
        
        // Divide o conteúdo em comandos individuais
        $commands = array_filter(
            explode(";\n", $sqlContent),
            function($cmd) { return trim($cmd) != ''; }
        );
        
        // Executa cada comando
        foreach ($commands as $command) {
            $command = trim($command);
            if (!empty($command)) {
                try {
                    $db->exec($command);
                } catch (PDOException $e) {
                    // Ignora erros específicos
                    $errorCode = $e->getCode();
                    if (!in_array($errorCode, ['42S01', '42S02'])) { // Ignora "tabela existe" e "tabela não existe"
                        throw new Exception('Erro ao executar comando SQL: ' . $e->getMessage());
                    }
                }
            }
        }
        
        echo json_encode(['success' => true, 'message' => 'Banco de dados importado com sucesso!']);
    } finally {
        // Garante que as chaves estrangeiras sejam reativadas mesmo se houver erro
        $db->exec('SET FOREIGN_KEY_CHECKS = 1');
    }
    
} catch (Exception $e) {
    http_response_code(500);
    echo json_encode(['error' => $e->getMessage()]);
}
