<?php
// Desativa a exibição de erros
error_reporting(0);
ini_set('display_errors', 0);

// Garante que nenhum output foi enviado antes
if (ob_get_length()) ob_clean();

header('Content-Type: application/json');

require_once '../includes/config.php';
require_once '../includes/functions.php';

try {
    $pdo = getConnection();
    
    // Busca o total de vendas incluindo pagamentos parciais
    $query = "
        SELECT (
            -- Vendas à vista (não crediário)
            (SELECT COALESCE(SUM(valor_total), 0)
            FROM operacoes 
            WHERE tipo = 'venda'
            AND status = 'ativo'
            AND afeta_caixa = 1
            AND deleted_at IS NULL
            AND LOWER(metodo_pagamento) != 'crediario')
            +
            -- Pagamentos parciais de crediário
            (SELECT COALESCE(SUM(pp.valor), 0)
            FROM pagamentos_parciais pp
            INNER JOIN operacoes o ON o.id = pp.venda_id
            WHERE o.tipo = 'venda'
            AND o.deleted_at IS NULL)
        ) as total_vendas
    ";
    
    $stmt = $pdo->query($query);
    $resultado = $stmt->fetch(PDO::FETCH_ASSOC);
    
    die(json_encode([
        'success' => true,
        'data' => [
            'total_vendas' => number_format($resultado['total_vendas'], 2, '.', '')
        ]
    ]));

} catch (Exception $e) {
    die(json_encode([
        'success' => false,
        'message' => 'Erro ao buscar total de vendas: ' . $e->getMessage()
    ]));
}
