<?php
require_once '../includes/config.php';

header('Content-Type: application/json');

try {
    $pdo = getConnection();
    
    $query = "SELECT * FROM config_site LIMIT 1";
    $stmt = $pdo->prepare($query);
    $stmt->execute();
    $config = $stmt->fetch(PDO::FETCH_ASSOC);
    
    if (!$config) {
        // Se não houver configurações, retorna valores padrão
        $config = [
            'site_ativo' => 1,
            'slide_ativo' => 1,
            'ultima_atualizacao' => date('Y-m-d H:i:s'),
            'slide_texto_principal' => 'Bem-vinda à Loja',
            'slide_texto_secundario' => 'Encontre as melhores peças aqui',
            'slide_image' => ''
        ];
    }
    
    echo json_encode([
        'success' => true,
        'data' => $config
    ]);
    
} catch (Exception $e) {
    error_log("Erro ao buscar configurações do site: " . $e->getMessage());
    echo json_encode([
        'success' => false,
        'message' => 'Erro ao buscar configurações do site'
    ]);
}
