<?php
require_once '../includes/functions.php';

if (!isset($_GET['id'])) {
    echo json_encode(['success' => false, 'message' => 'ID da prova não fornecido']);
    exit;
}

$prova_id = $_GET['id'];
$pdo = getConnection();

try {
    // Busca informações da prova
    $stmt = $pdo->prepare("
        SELECT p.*, c.nome as cliente_nome 
        FROM operacoes p 
        JOIN clientes c ON p.cliente_id = c.id 
        WHERE p.id = ? AND p.tipo = 'prova' AND p.deleted_at IS NULL
    ");
    $stmt->execute([$prova_id]);
    $prova = $stmt->fetch(PDO::FETCH_ASSOC);

    if (!$prova) {
        echo json_encode(['success' => false, 'message' => 'Prova não encontrada']);
        exit;
    }

    // Busca os itens da prova
    $stmt = $pdo->prepare("
        SELECT pi.*, p.nome as produto_nome 
        FROM operacao_itens pi 
        JOIN produtos p ON pi.produto_id = p.id 
        WHERE pi.operacao_id = ? AND pi.deleted_at IS NULL
    ");
    $stmt->execute([$prova_id]);
    $itens = $stmt->fetchAll(PDO::FETCH_ASSOC);

    $prova['itens'] = $itens;

    echo json_encode([
        'success' => true,
        'data' => $prova
    ]);

} catch (PDOException $e) {
    echo json_encode(['success' => false, 'message' => 'Erro ao buscar dados da prova: ' . $e->getMessage()]);
}
