<?php
require_once '../includes/config.php';
require_once '../includes/functions.php';

header('Content-Type: application/json');

try {
    $pdo = getConnection();
    
    $query = "
        SELECT DISTINCT
            p.id,
            p.nome
        FROM produtos p
        INNER JOIN operacao_itens oi ON oi.produto_id = p.id
        WHERE p.deleted_at IS NULL
        ORDER BY p.nome
    ";
    
    $stmt = $pdo->query($query);
    $produtos = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    echo json_encode([
        'success' => true,
        'data' => $produtos
    ]);

} catch (Exception $e) {
    http_response_code(500);
    echo json_encode([
        'success' => false,
        'message' => 'Erro ao buscar produtos: ' . $e->getMessage()
    ]);
}
