<?php
require_once '../includes/config.php';
require_once '../includes/functions.php';

header('Content-Type: application/json');

try {
    $pdo = getConnection();
    
    // Primeiro, busca os produtos com informações básicas
    $query = "
        SELECT 
            p.id,
            p.nome,
            p.valor,
            p.imagem,
            p.cor,
            c.nome as categoria,
            COALESCE(SUM(pt.estoque), 0) as estoque_total
        FROM produtos p
        LEFT JOIN categorias c ON c.id = p.categoria_id
        LEFT JOIN produto_tamanhos pt ON pt.produto_id = p.id
        WHERE p.deleted_at IS NULL
        GROUP BY p.id, p.nome, p.valor, p.imagem, p.cor, c.nome
        ORDER BY p.nome
    ";
    
    $stmt = $pdo->query($query);
    $produtos = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    // Para cada produto, busca seus tamanhos e estoques
    foreach ($produtos as &$produto) {
        $query_tamanhos = "
            SELECT tamanho, estoque
            FROM produto_tamanhos
            WHERE produto_id = ?
            ORDER BY tamanho
        ";
        
        $stmt_tamanhos = $pdo->prepare($query_tamanhos);
        $stmt_tamanhos->execute([$produto['id']]);
        $tamanhos = $stmt_tamanhos->fetchAll(PDO::FETCH_ASSOC);
        
        // Adiciona arrays de tamanhos e estoques ao produto
        $produto['tamanhos'] = array_column($tamanhos, 'tamanho');
        $produto['estoques'] = array_column($tamanhos, 'estoque');
    }
    
    echo json_encode($produtos);

} catch (Exception $e) {
    http_response_code(500);
    echo json_encode([
        'error' => 'Erro ao buscar produtos',
        'message' => $e->getMessage()
    ]);
}
