<?php
// Desativa a exibição de erros
error_reporting(0);
ini_set('display_errors', 0);

// Garante que nenhum output foi enviado antes
if (ob_get_length()) ob_clean();

header('Content-Type: application/json');

require_once '../includes/config.php';
require_once '../includes/functions.php';

try {
    if (!isset($_GET['id'])) {
        throw new Exception('ID do produto não fornecido');
    }

    $produtoId = $_GET['id'];
    $pdo = getConnection();

    // Busca o valor do produto
    $query = "SELECT valor FROM produtos WHERE id = ? AND deleted_at IS NULL";
    $stmt = $pdo->prepare($query);
    $stmt->execute([$produtoId]);
    
    $produto = $stmt->fetch(PDO::FETCH_ASSOC);
    
    if (!$produto) {
        throw new Exception('Produto não encontrado');
    }

    die(json_encode([
        'success' => true,
        'data' => [
            'valor' => $produto['valor']
        ]
    ]));

} catch (Exception $e) {
    die(json_encode([
        'success' => false,
        'message' => 'Erro ao buscar valor do produto: ' . $e->getMessage()
    ]));
}
