<?php
// Desativa a exibição de erros
error_reporting(0);
ini_set('display_errors', 0);

// Garante que nenhum output foi enviado antes
if (ob_get_length()) ob_clean();

header('Content-Type: application/json');

require_once '../includes/config.php';
require_once '../includes/functions.php';

try {
    if (!isset($_GET['id'])) {
        throw new Exception('ID do produto não fornecido');
    }

    $produtoId = $_GET['id'];
    $pdo = getConnection();

    // Busca apenas tamanhos com estoque maior que 0
    $query = "
        SELECT tamanho, estoque
        FROM produto_tamanhos
        WHERE produto_id = ? 
        AND estoque > 0
        ORDER BY tamanho
    ";

    $stmt = $pdo->prepare($query);
    $stmt->execute([$produtoId]);
    $tamanhos = $stmt->fetchAll(PDO::FETCH_ASSOC);

    // Separa tamanhos e estoques em arrays
    $response = [
        'success' => true,
        'data' => [
            'tamanhos' => array_column($tamanhos, 'tamanho'),
            'estoques' => array_column($tamanhos, 'estoque')
        ]
    ];

    die(json_encode($response));

} catch (Exception $e) {
    die(json_encode([
        'success' => false,
        'message' => 'Erro ao buscar tamanhos: ' . $e->getMessage()
    ]));
}
