<?php
require_once '../includes/config.php';
require_once '../includes/functions.php';

header('Content-Type: application/json');

try {
    if (!isset($_GET['id'])) {
        throw new Exception('ID do produto não informado');
    }

    $id = filter_input(INPUT_GET, 'id', FILTER_SANITIZE_NUMBER_INT);
    
    $pdo = getConnection();
    
    // Busca dados do produto
    $query = "
        SELECT 
            p.id,
            p.nome,
            p.valor,
            p.categoria_id,
            p.imagem,
            p.cor
        FROM produtos p
        WHERE p.id = :id AND p.deleted_at IS NULL
    ";
    
    $stmt = $pdo->prepare($query);
    $stmt->execute(['id' => $id]);
    $produto = $stmt->fetch(PDO::FETCH_ASSOC);
    
    if (!$produto) {
        throw new Exception('Produto não encontrado');
    }

    // Debug
    error_log("Produto encontrado: " . json_encode($produto));

    // Busca os tamanhos e estoques do produto
    $query = "
        SELECT tamanho, estoque
        FROM produto_tamanhos
        WHERE produto_id = :produto_id
        ORDER BY tamanho
    ";
    
    $stmt = $pdo->prepare($query);
    $stmt->execute(['produto_id' => $id]);
    $tamanhos = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    // Debug
    error_log("Tamanhos encontrados: " . json_encode($tamanhos));
    
    $produto['tamanhos'] = $tamanhos;
    
    echo json_encode([
        'success' => true,
        'data' => $produto
    ]);

} catch (Exception $e) {
    http_response_code(400);
    echo json_encode([
        'success' => false,
        'message' => $e->getMessage()
    ]);
}
