<?php
header('Content-Type: application/json');
require_once '../config/database.php';

try {
    $database = new Database();
    $db = $database->getConnection();

    $query = "SELECT * FROM config_history ORDER BY created_at DESC";
    $stmt = $db->prepare($query);
    $stmt->execute();

    $data = $stmt->fetchAll(PDO::FETCH_ASSOC);
    echo json_encode(['success' => true, 'data' => $data]);

} catch(PDOException $e) {
    echo json_encode(['success' => false, 'message' => 'Erro ao buscar histórico: ' . $e->getMessage()]);
}
?>
