<?php
header('Content-Type: application/json');
require_once '../config/database.php';

try {
    $database = new Database();
    $db = $database->getConnection();
    
    // Busca total de clientes ativos
    $query = "SELECT COUNT(1) as total FROM clientes WHERE deleted_at IS NULL";
    $stmt = $db->prepare($query);
    
    if ($stmt->execute()) {
        $result = $stmt->fetch(PDO::FETCH_ASSOC);
        $clientes = intval($result['total']);
        error_log("Total de clientes ativos encontrados: " . $clientes);
    } else {
        $error = $stmt->errorInfo();
        error_log("Erro ao buscar clientes: " . print_r($error, true));
        $clientes = 0;
    }
    
    // Busca total de produtos (apenas não excluídos)
    $produtos = 0;
    try {
        $query = "SELECT COUNT(1) as total FROM produtos WHERE deleted_at IS NULL";
        $stmt = $db->prepare($query);
        if ($stmt->execute()) {
            $produtos = intval($stmt->fetch(PDO::FETCH_ASSOC)['total']);
            error_log("Total de produtos ativos encontrados: " . $produtos);
        }
    } catch (Exception $e) {
        error_log("Erro ao buscar produtos: " . $e->getMessage());
    }
    
    // Busca total de provas pendentes
    $provas = 0;
    try {
        $query = "SELECT COUNT(1) as total FROM operacoes WHERE tipo = 'prova' AND status = 'ativo' AND deleted_at IS NULL";
        $stmt = $db->prepare($query);
        if ($stmt->execute()) {
            $provas = intval($stmt->fetch(PDO::FETCH_ASSOC)['total']);
            error_log("Total de provas pendentes encontradas: " . $provas);
        }
    } catch (Exception $e) {
        error_log("Erro ao buscar provas: " . $e->getMessage());
    }
    
    // Busca total de vendas
    $vendas = 0;
    $debug_info = [];
    
    try {
        // Soma vendas que não são crediário (dinheiro, pix, cartão, etc)
        $query = "SELECT COALESCE(SUM(valor_total), 0) as total 
                 FROM operacoes 
                 WHERE tipo = 'venda' 
                 AND metodo_pagamento != 'crediario'
                 AND status = 'ativo' 
                 AND deleted_at IS NULL";
        $stmt = $db->prepare($query);
        if ($stmt->execute()) {
            $result = $stmt->fetch(PDO::FETCH_ASSOC);
            $vendas_diretas = floatval($result['total']);
            $debug_info['vendas_diretas'] = $result;
        }

        // Soma TODOS os pagamentos parciais, independente do status da venda
        $query = "SELECT COALESCE(SUM(pp.valor), 0) as total 
                 FROM pagamentos_parciais pp
                 INNER JOIN operacoes o ON o.id = pp.venda_id
                 WHERE o.tipo = 'venda'
                 AND o.metodo_pagamento = 'crediario'
                 AND o.deleted_at IS NULL";
        $stmt = $db->prepare($query);
        if ($stmt->execute()) {
            $result = $stmt->fetch(PDO::FETCH_ASSOC);
            $pagamentos_parciais = floatval($result['total']);
            $debug_info['pagamentos_parciais'] = $result;
        }

        // Soma total (vendas diretas + pagamentos parciais do crediário)
        $vendas = $vendas_diretas + $pagamentos_parciais;
        $debug_info['total_geral'] = [
            'vendas_diretas' => $vendas_diretas,
            'pagamentos_parciais' => $pagamentos_parciais,
            'total' => $vendas
        ];
        
    } catch (Exception $e) {
        $debug_info['erro_geral'] = $e->getMessage();
    }
    
    echo json_encode([
        'clientes' => $clientes,
        'produtos' => $produtos,
        'provas' => $provas,
        'vendas' => $vendas,
        'debug' => $debug_info
    ], JSON_PRETTY_PRINT);

} catch (Exception $e) {
    error_log("Erro geral no dashboard: " . $e->getMessage());
    http_response_code(500);
    echo json_encode(['error' => 'Erro ao buscar dados do dashboard']);
}
