<?php
header('Content-Type: application/json');
require_once '../config/database.php';

try {
    $database = new Database();
    $db = $database->getConnection();

    $type = $_GET['type'] ?? '';
    $response = ['success' => 0, 'message' => 'Tipo não especificado'];

    switch($type) {
        case 'empresa':
            // Buscar dados da empresa
            $query = "SELECT * FROM config_empresa WHERE id = 1";
            $stmt = $db->prepare($query);
            
            if ($stmt->execute()) {
                $empresa = $stmt->fetch(PDO::FETCH_ASSOC);
                
                // Buscar cores da tabela config_estilo_cores
                $cores_query = "SELECT * FROM config_estilo_cores WHERE id = 1";
                $cores_stmt = $db->prepare($cores_query);
                
                if ($cores_stmt->execute()) {
                    $cores = $cores_stmt->fetch(PDO::FETCH_ASSOC);
                    if ($cores) {
                        // Mesclar dados da empresa com as cores
                        $empresa = array_merge($empresa, $cores);
                    }
                }
                
                if ($empresa) {
                    $response = [
                        'success' => 1,
                        'data' => $empresa
                    ];
                } else {
                    $response = [
                        'success' => 0,
                        'message' => 'Nenhuma configuração encontrada'
                    ];
                }
            } else {
                $response = [
                    'success' => 0,
                    'message' => 'Erro ao buscar configurações'
                ];
            }
            break;

        case 'redes':
            // Buscar dados das redes sociais
            $query = "SELECT * FROM config_redes_sociais WHERE id = 1";
            $stmt = $db->prepare($query);
            
            if ($stmt->execute()) {
                $redes = $stmt->fetch(PDO::FETCH_ASSOC);
                if ($redes) {
                    $response = [
                        'success' => 1,
                        'data' => $redes
                    ];
                } else {
                    $response = [
                        'success' => 0,
                        'message' => 'Nenhuma configuração de redes sociais encontrada'
                    ];
                }
            } else {
                $response = [
                    'success' => 0,
                    'message' => 'Erro ao buscar configurações de redes sociais'
                ];
            }
            break;

        case 'estilo':
            // Buscar dados de estilo
            $query = "SELECT * FROM config_estilo_cores WHERE id = 1";
            $stmt = $db->prepare($query);
            
            if ($stmt->execute()) {
                $estilo = $stmt->fetch(PDO::FETCH_ASSOC);
                if ($estilo) {
                    $response = [
                        'success' => 1,
                        'data' => $estilo
                    ];
                } else {
                    $response = [
                        'success' => 0,
                        'message' => 'Nenhuma configuração de estilo encontrada'
                    ];
                }
            } else {
                $response = [
                    'success' => 0,
                    'message' => 'Erro ao buscar configurações de estilo'
                ];
            }
            break;
    }

} catch (Exception $e) {
    error_log("Erro ao buscar configurações: " . $e->getMessage());
    $response = [
        'success' => 0,
        'message' => 'Erro ao buscar configurações: ' . $e->getMessage()
    ];
}

echo json_encode($response);
?>
