<?php
require_once '../includes/config.php';
require_once '../includes/functions.php';

header('Content-Type: application/json');

try {
    $pdo = getConnection();
    
    // Log da conexão
    error_log("Conexão PDO estabelecida");
    
    // Primeiro, vamos verificar se a conexão está funcionando
    if (!$pdo) {
        throw new Exception("Erro na conexão com o banco de dados");
    }
    
    // Pega o termo de busca do Select2
    $search = isset($_GET['q']) ? $_GET['q'] : '';
    error_log("Termo de busca: " . $search);
    
    // Primeiro, vamos verificar se a tabela existe
    $tableExists = $pdo->query("SHOW TABLES LIKE 'clientes'")->rowCount() > 0;
    if (!$tableExists) {
        throw new Exception("Tabela 'clientes' não encontrada");
    }
    
    // Verifica a estrutura da tabela
    $columns = $pdo->query("SHOW COLUMNS FROM clientes")->fetchAll(PDO::FETCH_COLUMN);
    error_log("Colunas na tabela clientes: " . implode(", ", $columns));
    
    $query = "
        SELECT 
            id,
            nome,
            telefone,
            CONCAT(nome, ' (', telefone, ')') as text
        FROM clientes 
        WHERE telefone IS NOT NULL 
        AND telefone != ''
        AND deleted_at IS NULL
    ";
    
    // Adiciona filtro de busca se houver termo
    if (!empty($search)) {
        $query .= " AND (nome LIKE :search OR telefone LIKE :search)";
    }
    
    $query .= " ORDER BY nome LIMIT 50";
    
    error_log("Query SQL: " . $query);
    
    $stmt = $pdo->prepare($query);
    
    // Bind do parâmetro de busca se existir
    if (!empty($search)) {
        $searchTerm = "%{$search}%";
        $stmt->bindParam(':search', $searchTerm, PDO::PARAM_STR);
        error_log("Termo de busca preparado: " . $searchTerm);
    }
    
    $stmt->execute();
    error_log("Query executada");
    
    $clientes = $stmt->fetchAll(PDO::FETCH_ASSOC);
    error_log("Número de clientes encontrados: " . count($clientes));
    
    $response = [
        'results' => array_map(function($cliente) {
            return [
                'id' => $cliente['id'],
                'text' => $cliente['text']
            ];
        }, $clientes),
        'pagination' => ['more' => false]
    ];
    
    error_log("Resposta JSON: " . json_encode($response));
    echo json_encode($response);

} catch (Exception $e) {
    error_log("Erro em get_clientes_telefone.php: " . $e->getMessage());
    http_response_code(500);
    echo json_encode([
        'error' => $e->getMessage()
    ]);
}
